
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: dscheme.h,v 1.4 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality/GUI
 * File:	dscheme.h
 * Author:      Michal Safranek
 * Description: Default color scheme
 */

#ifndef __DSCHEME_H__
#define __DSCHEME_H__

#include "tn.h"



/* Default color scheme */
color default_color_scheme[] = {
	/* checkbox: */
	Black,		/* COLOR_CHECKBOX_BG */
	Black,		/* COLOR_CHECKBOX_LABELBG */
	Black,		/* COLOR_CHECKBOX_CHECKBG */
	Black,		/* COLOR_CHECKBOX_BOXBG */
	Black,		/* COLOR_CHECKBOX_SLABELBG */
	Black,		/* COLOR_CHECKBOX_SCHECKBG */
	Black,		/* COLOR_CHECKBOX_SBOXBG */
	LightGray,	/* COLOR_CHECKBOX_LABEL */
	White,		/* COLOR_CHECKBOX_SLABEL */
	Green,		/* COLOR_CHECKBOX_BOX */
	Green,		/* COLOR_CHECKBOX_SCHECK */
	LightGreen,	/* COLOR_CHECKBOX_SBOX */
	LightGreen,	/* COLOR_CHECKBOX_CHECK */
	/* Button: */
	Black,		/* COLOR_BUTTON_BG */
	LightGray,	/* COLOR_BUTTON_TEXT */
	Green,		/* COLOR_BUTTON_BR */
	Green,		/* COLOR_BUTTON_STL */
	LightGreen,	/* COLOR_BUTTON_SBR */
	LightGreen,	/* COLOR_BUTTON_TL */
	White,		/* COLOR_BUTTON_STEXT */
	Green,		/* COLOR_BUTTON_DTEXT */
	LightGreen,	/* COLOR_BUTTON_SDTEXT */
	/* Form: */
	Black,		/* COLOR_FORM_BG */
	LightGreen,	/* COLOR_FORM_TL */
	Green,		/* COLOR_FORM_BR */
	/* hMenu: */
	Black,		/* COLOR_HMENU_BG */
	Black,		/* COLOR_HMENU_SITEMBG */
	Black,		/* COLOR_HMENU_ITEMBG */
	Green,		/* COLOR_HMENU_ITEM */
	LightGreen,	/* COLOR_HMENU_SITEM */
	/* listingItem: */
	Black,		/* COLOR_LITEM_ITEMBG */
	Black,		/* COLOR_LITEM_EMPTYBG */
	Black,		/* COLOR_LITEM_HEADINGBG */
	Black,		/* COLOR_LITEM_MOREBG */
	LightGreen,	/* COLOR_LITEM_MORE */
	LightGreen,	/* COLOR_LITEM_HEADING */
	Green,		/* COLOR_LITEM_ITEM */
	Green,		/* COLOR_LITEM_SITEMBG */
	Green,		/* COLOR_LITEM_SMOREBG */
	Red,		/* COLOR_LITEM_EMPTY */
	Red,		/* COLOR_LITEM_SEMPTYBG */
	Black,		/* COLOR_LITEM_SITEM */
	Black,		/* COLOR_LITEM_SEMPTY */
	Black,		/* COLOR_LITEM_SMORE */
	/* listing: */
	Black,		/* COLOR_LISTING_BG */
	/* menu: */
	Black,		/* COLOR_MENU_FRAMEBG */
	Black,		/* COLOR_MENU_ITEMBG */
	LightGreen,	/* COLOR_MENU_SCROLL */
	LightGreen,	/* COLOR_MENU_FRAME */
	LightGreen,	/* COLOR_MENU_CORNER */
	Green,		/* COLOR_MENU_ITEM */
	LightGreen,	/* COLOR_MENU_SITEM */
	Green,		/* COLOR_MENU_SITEMBG */
	/* textbox: */
	Green,		/* COLOR_TEXTBOX_FRAME */
	Green,		/* COLOR_TEXTBOX_SPACE */
	Green,		/* COLOR_TEXTBOX_SSPACE */
	Black,		/* COLOR_TEXTBOX_TEXTBG */
	Black,		/* COLOR_TEXTBOX_SPACEBG */
	Black,		/* COLOR_TEXTBOX_FRAMEBG */
	Black,		/* COLOR_TEXTBOX_STEXTBG */
	Black,		/* COLOR_TEXTBOX_SSPACEBG */
	Black,		/* COLOR_TEXTBOX_SFRAMEBG */
	LightGray,	/* COLOR_TEXTBOX_TEXT */
	White,		/* COLOR_TEXTBOX_STEXT */
	LightGreen,	/* COLOR_TEXTBOX_SFRAME */
	/* staticLabel: */
	Black,		/* COLOR_SLABEL_BG */
	LightGreen,	/* COLOR_SLABEL_FG */
	/* textarea: */
	Green,		/* COLOR_TEXTAREA_FRAME */
	Green,		/* COLOR_TEXTAREA_SPACE */
	Green,		/* COLOR_TEXTAREA_SSPACE */
	Black,		/* COLOR_TEXTAREA_TEXTBG */
	Black,		/* COLOR_TEXTAREA_SPACEBG */
	Black,		/* COLOR_TEXTAREA_FRAMEBG */
	Black,		/* COLOR_TEXTAREA_STEXTBG */
	Black,		/* COLOR_TEXTAREA_SSPACEBG */
	Black,		/* COLOR_TEXTAREA_SFRAMEBG */
	LightGray,	/* COLOR_TEXTAREA_TEXT */
	White,		/* COLOR_TEXTAREA_STEXT */
	LightGreen,	/* COLOR_TEXTAREA_SFRAME */
	Black,		/* COLOR_PBAR_BG */
	DarkGray,	/* COLOR_PBAR_NONE */
	Red,		/* COLOR_PBAR_LOW */
	Brown,		/* COLOR_PBAR_MID */
	Green,		/* COLOR_PBAR_HI */
	White,		/* COLOR_PBAR_PERC */
};

/* SafeGuard */
#define DEFAULT_SCHEME_COLORS (sizeof(default_color_scheme)/sizeof(color))-1

#endif

