
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: extra.h,v 1.19 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality
 * File:	extra.h
 * Author:      Emil Mikulic
 * Description: Provide interface for extra functions
 */

#ifndef _extra_h_
#define _extra_h_

#include "tn.h"
#include "xmem.h"

#ifdef __cplusplus
extern "C" {
#endif

/* Box functions */
void drawbox(int x1, int y1, int x2, int y2);	/* Simple box */
void box_3d(int x1, int y1, int x2, int y2, color basecolor,
	color lite, color dark);		/* 3d box */

/* in/out 3d boxes */
#define drawbox_in(x1,y1,x2,y2,c) \
	box_3d(x1,y1,x2,y2,c,Black,(color)(c+8))

#define drawbox_out(x1,y1,x2,y2,c) \
	box_3d(x1,y1,x2,y2,c,(color)(c+8),Black)

/* Text functions */
int printc(char *format, ...);
int writexy(int x, int y, char *format, ...);
int center(int y, char *format, ...);

/* Other stuff */
void fillscreen(color f, color b, chtype c);
void textviewer(int x, int y, int w, int h, char *ttbuf);

#ifdef __cplusplus
}
#endif

#endif

