
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: tn_h_nc.h,v 1.2 2002/07/26 09:01:58 darkmoon Exp $ */

/* Project:     Terminality
 * File:	tn_nc.h
 * Description: Provides ncurses interface changes
 */

#ifndef _tn_nc_h_
#define _tn_nc_h_

#define TN_H_IMPLEMENTED

/* avoid printw() definition clash */
#define printw ncurses_printw

/* (n/pd)curses includes */
#if __DJGPP__ || __sun__
#include <curses.h>
#else
#include <ncurses.h>
#endif

/* get rid of it now */
#undef printw

/* ncurses specifics */
int initcolor(void);

/* Special character macro */
#define CTRLCHAR (1 << 22)
#define _c(x) ((x) | CTRLCHAR)

/* Special character set */
#define HLINE	ACS_HLINE
#define VLINE	ACS_VLINE
#define CROSS	ACS_PLUS
#define C_UL	ACS_ULCORNER
#define C_UR	ACS_URCORNER
#define C_LL	ACS_LLCORNER
#define C_LR	ACS_LRCORNER
#define BLOCK_1	_c(176)		/*ACS_BOARD*/
#define BLOCK_2	_c(177)		/*ACS_CKBOARD*/
#define BLOCK_3 _c(178)
#define BLOCK_4 _c(219)		/*ACS_BLOCK*/
#define TEE_L	ACS_RTEE
#define TEE_R	ACS_LTEE
#define TEE_U	ACS_BTEE
#define TEE_D	ACS_TTEE
#define ARROW_L	ACS_LARROW
#define ARROW_R	ACS_RARROW
#define ARROW_U	ACS_UARROW
#define ARROW_D	ACS_DARROW

/* Console size */
#define CON_COLS COLS
#define CON_ROWS LINES

#define key int
#undef KEY_ENTER
#define KEY_ENTER '\r'
#define KEY_INS KEY_IC
#define KEY_DEL KEY_DC
#define KEY_ESC 27
#define KEY_PGUP KEY_PPAGE
#define KEY_PGDOWN KEY_NPAGE
#define KEY_TAB '\t'
#ifdef __DJGPP__
#undef KEY_BACKSPACE
#define KEY_BACKSPACE '\b'
#endif
#define KEY_REDRAW 12
#define KEY_NOTHING 32101
#define KEY_SUPERVISE (KEY_NOTHING + 1) /* Virtual key */


/* Kill clear and erase so <vector> doesn't choke on them */
#undef clear
#undef erase

#endif

