
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: xmem.h,v 1.5 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality
 * File:	xmem.h
 * Author:      Michal Safranek, Emil Mikulic
 * Description: Safe memory functions
 */



#ifndef __XMEM_H__
#define __XMEM_H__

#include <stdio.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif



/* functions will print debug messages if xmem_want_debug != 0 */
extern int xmem_want_debug;

/* debug messages go to... */
#ifndef xmem_debug_fd
#define xmem_debug_fd stderr
#endif



/* allocates memory || dies when it goes OOM */
void *xmalloc(size_t bytes);

/* reallocates memory || dies when it goes OOM */
void *xrealloc(void *ptr, size_t bytes);

/* frees memory */
void xfree(void *ptr);



#ifdef __cplusplus
}
#endif

#endif

