
/* Terminality - a portable terminal handling library
 * Copyright (C) 1998-2002, Emil Mikulic.
 * This is LGPL - look at COPYING.LIB
 */

/* $Id: colors.h,v 1.5 2002/07/26 01:39:40 darkmoon Exp $ */

/* Project:     Terminality
 * File:	colors.h
 * Author:      Michal Safranek
 * Description: Color themes
 */

#ifndef __COLORS_H__
#define __COLORS_H__

#include "tn.h"

/* CheckBox */
#define COLOR_CHECKBOX_BG	get_scheme_color(0)
#define COLOR_CHECKBOX_LABELBG	get_scheme_color(1)
#define COLOR_CHECKBOX_CHECKBG	get_scheme_color(2)
#define COLOR_CHECKBOX_BOXBG	get_scheme_color(3)
#define COLOR_CHECKBOX_SLABELBG	get_scheme_color(4)
#define COLOR_CHECKBOX_SCHECKBG	get_scheme_color(5)
#define COLOR_CHECKBOX_SBOXBG	get_scheme_color(6)
#define COLOR_CHECKBOX_LABEL	get_scheme_color(7)
#define COLOR_CHECKBOX_SLABEL	get_scheme_color(8)
#define COLOR_CHECKBOX_BOX	get_scheme_color(9)
#define COLOR_CHECKBOX_SCHECK	get_scheme_color(10)
#define COLOR_CHECKBOX_SBOX	get_scheme_color(11)
#define COLOR_CHECKBOX_CHECK	get_scheme_color(12)

/* Button */
#define COLOR_BUTTON_BG		get_scheme_color(13)
#define COLOR_BUTTON_TEXT	get_scheme_color(14)
#define COLOR_BUTTON_BR		get_scheme_color(15)
#define COLOR_BUTTON_STL	get_scheme_color(16)
#define COLOR_BUTTON_SBR	get_scheme_color(17)
#define COLOR_BUTTON_TL		get_scheme_color(18)
#define COLOR_BUTTON_STEXT	get_scheme_color(19)
#define COLOR_BUTTON_DTEXT	get_scheme_color(20)
#define COLOR_BUTTON_SDTEXT	get_scheme_color(21)

/* Form */
#define COLOR_FORM_BG		get_scheme_color(22)
#define COLOR_FORM_TL		get_scheme_color(23)
#define COLOR_FORM_BR		get_scheme_color(24)

/* hMenu */
#define COLOR_HMENU_BG		get_scheme_color(25)
#define COLOR_HMENU_SITEMBG	get_scheme_color(26)
#define COLOR_HMENU_ITEMBG	get_scheme_color(27)
#define COLOR_HMENU_ITEM	get_scheme_color(28)
#define COLOR_HMENU_SITEM	get_scheme_color(29)

/* listingItem */
#define COLOR_LITEM_ITEMBG	get_scheme_color(30)
#define COLOR_LITEM_EMPTYBG	get_scheme_color(31)
#define COLOR_LITEM_HEADINGBG	get_scheme_color(32)
#define COLOR_LITEM_MOREBG	get_scheme_color(33)
#define COLOR_LITEM_MORE	get_scheme_color(34)
#define COLOR_LITEM_HEADING	get_scheme_color(35)
#define COLOR_LITEM_ITEM	get_scheme_color(36)
#define COLOR_LITEM_SITEMBG	get_scheme_color(37)
#define COLOR_LITEM_SMOREBG	get_scheme_color(38)
#define COLOR_LITEM_EMPTY	get_scheme_color(39)
#define COLOR_LITEM_SEMPTYBG	get_scheme_color(40)
#define COLOR_LITEM_SITEM	get_scheme_color(41)
#define COLOR_LITEM_SEMPTY	get_scheme_color(42)
#define COLOR_LITEM_SMORE	get_scheme_color(43)

/* Listing */
#define COLOR_LISTING_BG	get_scheme_color(44)

/* Menu */
#define COLOR_MENU_FRAMEBG	get_scheme_color(45)
#define COLOR_MENU_ITEMBG	get_scheme_color(46)
#define COLOR_MENU_SCROLL	get_scheme_color(47)
#define COLOR_MENU_FRAME	get_scheme_color(48)
#define COLOR_MENU_CORNER	get_scheme_color(49)
#define COLOR_MENU_ITEM		get_scheme_color(50)
#define COLOR_MENU_SITEM	get_scheme_color(51)
#define COLOR_MENU_SITEMBG	get_scheme_color(52)

/* Textbox */
#define COLOR_TEXTBOX_FRAME	get_scheme_color(53)
#define COLOR_TEXTBOX_SPACE	get_scheme_color(54)
#define COLOR_TEXTBOX_SSPACE	get_scheme_color(55)
#define COLOR_TEXTBOX_TEXTBG	get_scheme_color(56)
#define COLOR_TEXTBOX_SPACEBG	get_scheme_color(57)
#define COLOR_TEXTBOX_FRAMEBG	get_scheme_color(58)
#define COLOR_TEXTBOX_STEXTBG	get_scheme_color(59)
#define COLOR_TEXTBOX_SSPACEBG	get_scheme_color(60)
#define COLOR_TEXTBOX_SFRAMEBG	get_scheme_color(61)
#define COLOR_TEXTBOX_TEXT	get_scheme_color(62)
#define COLOR_TEXTBOX_STEXT	get_scheme_color(63)
#define COLOR_TEXTBOX_SFRAME	get_scheme_color(64)

/* staticLabel */
#define COLOR_SLABEL_BG		get_scheme_color(65)
#define COLOR_SLABEL_FG		get_scheme_color(66)

/* Textbox */
#define COLOR_TEXTAREA_FRAME	get_scheme_color(67)
#define COLOR_TEXTAREA_SPACE	get_scheme_color(68)
#define COLOR_TEXTAREA_SSPACE	get_scheme_color(69)
#define COLOR_TEXTAREA_TEXTBG	get_scheme_color(70)
#define COLOR_TEXTAREA_SPACEBG	get_scheme_color(71)
#define COLOR_TEXTAREA_FRAMEBG	get_scheme_color(72)
#define COLOR_TEXTAREA_STEXTBG	get_scheme_color(73)
#define COLOR_TEXTAREA_SSPACEBG	get_scheme_color(74)
#define COLOR_TEXTAREA_SFRAMEBG	get_scheme_color(75)
#define COLOR_TEXTAREA_TEXT	get_scheme_color(76)
#define COLOR_TEXTAREA_STEXT	get_scheme_color(77)
#define COLOR_TEXTAREA_SFRAME	get_scheme_color(78)

/* Progress bar */
#define COLOR_PBAR_BG		get_scheme_color(79)
#define COLOR_PBAR_NONE		get_scheme_color(80)
#define COLOR_PBAR_LOW		get_scheme_color(81)
#define COLOR_PBAR_MID		get_scheme_color(82)
#define COLOR_PBAR_HI		get_scheme_color(83)
#define COLOR_PBAR_PERC		get_scheme_color(84)

/* Max color num */
#define MAX_SCHEME_COLOR_NUM	84

#endif

