
# Description:  This script allows you to play definable sounds on
#               certain events. It's also a nice example for using
#               tkirc's on-procedures. Please see the comments below!
#
# Date:         2000-08-27
# Author:       Andreas Gelhausen, atte@netsplit.de
#
# Changes:      2000-08-27  Changes for tkirc's first release of version 2.
#                  [..]
#
# Install:
#               1. copy this file to `~/.tkirc2/autoload/sound.tcl'
#               2. edit the following audio-variables
#                  (see examples and comments below)
#               3. reload your tkircrc or restart tkirc

global audio

# The following variable defines the program that will play
# your modules on certain events.

set audio(snd_program)        "/usr/local/bin/waveplay"

# Below you see module-settings for all events that tkirc knows. These
# modules are just examples. If you want to hear some of them, you must
# download it from somewhere in space or internet! =:^)

set audio(snd_join)           "/usr/local/audio/alarm.wav"
set audio(snd_leave)          "/usr/local/audio/alarm.wav"
#set audio(snd_signoff)        ""
#set audio(snd_disconnect)     ""
#set audio(snd_topic)          ""
#set audio(snd_modechange)     ""
#set audio(snd_nick)           ""
#set audio(snd_kick)           ""
#set audio(snd_ctcprequest)    ""
#set audio(snd_ctcpreply)      ""
#set audio(snd_dcc)            ""
#set audio(snd_privaction)     ""
#set audio(snd_pubaction)      ""
#set audio(snd_privmessage)    ""
#set audio(snd_pubmessage)     ""
#set audio(snd_servermessage)  ""
#set audio(snd_privnotice)     ""
#set audio(snd_pubnotice)      ""
#set audio(snd_servernotice)   ""
#set audio(snd_invite)         ""
#set audio(snd_notify_signon)  ""
#set audio(snd_notify_signoff) ""
#set audio(snd_url_detect)     ""
#set audio(snd_msgid_detect)   ""

#set audio(snd_tkircstart)     ""
#set audio(snd_ircIIstart)     ""
#set audio(snd_connect)        ""

proc on_event_snd { } {
  global on_args audio margin

  if {[info exists audio(snd_program)]} {
    if {[file exists $audio(snd_program)]} { 
      if {[info exists audio(snd_$on_args(event))]} {
        if {[file exists $audio(snd_$on_args(event))]} { 
          if {[string length "$audio(snd_$on_args(event))"]} {
            catch {
              eval exec -- $audio(snd_program) $audio(snd_$on_args(event)) &
	    }
	  }
        } else {
          set margin(text) "sound"
          write2crap $on_args(irc) " Failed to find sound file '$audio(snd_$on_args(event))'."
        }
      }
    } else {
      set margin(text) "sound"
      write2crap $on_args(irc) " Failed to find sound program '$audio(snd_program)'."
    }
  }
}
