;; Author: Leslie H. Watter <leslie@netpar.com.br>
;; Data inicial: No lembro (mais ou menos 3 semanas atrs
;;                           hoje = Sex Jun  7, 2002  1:44 )
;; ltima Modificao: Sex Jun  7, 2002  2:04 

;; Ah, este modo foi "baseado" no modo m4.
;;
;; Agradecimentos ao aurlio por ter feito o txt2tags e 
;; me incentivado durante o processo de criao deste :-)
;; Este modo est liberado sob a GPL. 
;; Se vc gostou deste modo me avise :-)




(defgroup txt2tags nil
  "txt2tags code editing commands for Emacs."
  :prefix "txt2tags-"
  :group 'languages)

(defcustom txt2tags-program 
  (cond 
   ((file-exists-p "/usr/local/bin/txt2tags") 
"/usr/local/bin/txt2tags")
   ((file-exists-p "/usr/bin/txt2tags") "/usr/bin/txt2tags")
   ((file-exists-p "/bin/txt2tags") "/bin/txt2tags")
   ((file-exists-p "/home/leslie/bin/bin/txt2tags") 
"/home/leslie/bin/bin/txt2tags")
   ( t "txt2tags")
   )
  "File name of the txt2tags executable."
  :type 'file
  :group 'txt2tags)


;; muda as cores de frente e fundo de algumas fontes :D

;; comentrios
 (set-face-foreground 'font-lock-comment-face       "yellow")        
 (set-face-background 'font-lock-comment-face       "black")        

;; Verbatim
 (set-face-foreground 'font-lock-keyword-face       "SpringGreen1") 
 (set-face-background 'font-lock-keyword-face       "black") 

;; http + e-mails
 (set-face-foreground 'font-lock-builtin-face       "dark orchid")
 (set-face-background 'font-lock-builtin-face       "black")

;; nmeros
 (set-face-foreground 'font-lock-function-name-face "plum1") 
 (set-face-background 'font-lock-function-name-face "black")     

;; ttulos de sees
 (set-face-foreground 'font-lock-type-face          "cyan") 
 (set-face-background 'font-lock-type-face          "black") 

;; comentrios
 (set-face-foreground 'font-lock-warning-face       "yellow4") 
 (set-face-background 'font-lock-warning-face       "black") 

;; seta os atributos da fonte :D
;; negrito
(set-face-attribute font-lock-reference-face nil 
:width 'extra-expanded
:weight 'extra-bold
:foreground "midnight blue"
:background "black" )

;; itlico
(set-face-attribute font-lock-constant-face nil 
;;:width 'extra-expanded
:slant 'italic
:foreground "SlateBlue2"
:background "black")    

;; negrito + itlico
(set-face-attribute font-lock-doc-face nil 
:width 'extra-expanded
:weight 'extra-bold
:slant 'italic
:underline nil
:foreground "medium slate blue"
:background "black" )

;; tabelas
(copy-face 'bold 'font-lock-variable-name-face)
(set-face-attribute font-lock-variable-name-face nil 
:foreground "turquoise4"   ;;"DarkOrchid1"
:background "black")    


;; sublinhado
(set-face-attribute font-lock-string-face nil 
:underline t
:foreground "SlateBlue2"
:background "black")    




;;options to txt2tags
;; ainda no descobri como usar :(
(defcustom txt2tags-program-options nil
  "Options to pass to `txt2tags-program'."
  :type '(repeat string)
  :group 'txt2tags)

(defvar txt2tags-font-lock-keywords
  `(
;; Comentrios
     ("^//.*" . font-lock-warning-face )
;; Titulos de Sees
;; ("=.*=" . font-lock-keyword-face)
;; regex de cima um pouco melhorada
     ("==?=?=?=?[- A-Za-z0-9]+==?=?=?=?" . font-lock-type-face) 
;; Data
     ("%?%?date\\((%[mMdDyY]-%[mMdDyY]-%[mMdDyY])\\)?" . 
font-lock-comment-face)
;; Negrito
     ("\\*\\*\\(\\sw\\|\\s_\\)+\\*\\*" . font-lock-reference-face)
;; Sublinhado
     ("__\\(\\sw\\|\\s_\\)+__" . font-lock-string-face)
;; trs primeira linhas de verbatim
     ("---\n.*\n.*\n.*\n---\n" . font-lock-keyword-face)
;; verbatim de uma linha s "--- blkah "
     ("^--- .*$" . font-lock-keyword-face)
;; verbatim
     ("`\\(\\sw\\|\\s_\\)+`" . font-lock-keyword-face)
;; Itlico
     ("//\\(\\sw\\| \\)+//" . font-lock-constant-face)
;; Negrito Itlico
     ("*/\\(\\sw\\|\\s_\\|\\ \\)+/\\*" . font-lock-doc-face)
;; colchetes - imagens
     ("\\[\\(.*\\|\.jpg\\|\.png\\|\.gif\\|\.tiff?\\)\\]" . 
font-lock-comment-face)
;; colchetes - links
     ("\\[\\(.*\\)\\]" . font-lock-variable-name-face)
;; pginas WEB
     ("\\(http\\|https\\|ftp\\|telnet\\)://[A-Za-z]+[.@][A-Za-z.:]+" . 
font-lock-builtin-face)
;; e-mails
     ("[A-Za-z0-9_.-]+@\\([A-Za-z0-9_-]+\.\\)+" . 
font-lock-builtin-face)
;; Tabela
     ;; linha de titulo de tabela COM e SEM os pipes
     ("^ ?||\\( |\\| \\|\t\\|\\sw\\)+" . font-lock-variable-name-face )
;; corpo da tabela
     ("^|\\(\\(\\s.\\|\\sw\\| \\)+\\( |\\)+\\)+" . 
font-lock-variable-name-face)
;; corpo da tabela sem pipes
     ("^|\\(\\(\\( \\|\t\\)\\(\\s.\\|\\sw\\| \\)+\\)\\)+" . 
font-lock-variable-name-face)
;; Listas -- (ainda nao vi como fazer com regioes inteiras)
;; Listas de itens
     ("^[ \t]*- +" . 'font-lock-comment-face )
;; listas numeradas
     ("^[ \t]*\\+ +" . 'font-lock-comment-face )
;; numeros com cor tambm
     (" -?[0-9.]+" . font-lock-function-name-face)
    "Default font-lock-keywords for txt2tags mode.")
)


(defcustom txt2tags-mode-hook nil
  "*Hook called by `txt2tags-mode'."
  :type 'hook
  :group 'txt2tags)

(defvar txt2tags-mode-map
  (let ((map (make-sparse-keymap)))
    (define-key map "\C-c\C-c" 'comment-region)
    map))

(defvar txt2tags-mode-abbrev-table nil
  "Abbrev table used while in text mode.")

(unless txt2tags-mode-abbrev-table
  (define-abbrev-table 'txt2tags-mode-abbrev-table ()))

;;;###autoload
(defun txt2tags-mode ()
  "A major mode to edit txt2tags macro files.
\\{txt2tags-mode-map}
"
  (interactive)
  (kill-all-local-variables)
  (use-local-map txt2tags-mode-map)

  (make-local-variable 'comment-start)
  (setq comment-start "//")
  (make-local-variable 'parse-sexp-ignore-comments)
  (setq parse-sexp-ignore-comments t)
  (setq local-abbrev-table txt2tags-mode-abbrev-table)

  (make-local-variable	'font-lock-defaults)  
  (setq major-mode 'txt2tags-mode
	mode-name "txt2tags"
	font-lock-defaults '(txt2tags-font-lock-keywords nil)
	)

  (run-hooks 'txt2tags-mode-hook))
  (setq auto-mode-alist
        (cons '("\\.\\(t2t\\|txt\\)$" . txt2tags-mode) 
auto-mode-alist))

(provide 'txt2tags-mode)
