/**
 *
 * VkAction.h
 *
 * This file contains the class declaration for the
 * VkAction class, which encapsulates the programmer's
 * interface to reversible commands.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKACTION_H
#define VKACTION_H

#include <Vk/VkConfig.h>
#include <Vk/VkMenuUndoManager.h>

class VkAction {
friend VkMenuUndoManager;

private:
  char *_name;
  char *_labelString;

public:
  VkAction(const char *name);

  virtual void doit() = 0;
  virtual void undoit() = 0;

  void execute();
};

#endif // VKACTION_H
