/**
 * 
 * $Id: VkComponent.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the 
 * VkComponent class.  This class is an abstract one,
 * meaning it doesn't make any sense to define an object
 * as a VkComponent.  It _does_ make sense to derive objects
 * from it.  It is derived from the VkCallbackObject class,
 * which allows any components to receive and register 
 * callbacks.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKCOMPONENT_H
#define VKCOMPONENT_H

#include <Xm/Xm.h>
#include <X11/Xresource.h>
#include <X11/Intrinsic.h>
#include <string.h>
#include <Vk/VkConfig.h>
#include <Vk/VkCallbackObject.h>

class VkComponent : public VkCallbackObject {

private:
    static void widgetDestroyedCallback(Widget w, XtPointer callData, XtPointer clientData);
    XrmDatabase xrm_db;

protected:
    char *_name;
    Widget _baseWidget;
    VkComponent(const char *name); 
    virtual void afterRealizeHook() {};

public:
    virtual ~VkComponent();
    Widget baseWidget(); 
    const char *name() const;

    void installDestroyHandler(); 
    void removeDestroyHandler(); 
    void setDefaultResources(const Widget parent,
			     const String *resourceSpec);
  
    void getResources (const XtResourceList resources,
		       const int numResources);
  
    virtual operator Widget() const; 
    virtual const char *className() = 0; 
    virtual void show(); 
    virtual void hide(); 
    virtual void widgetDestroyed(); 
    virtual Boolean okToQuit() { return TRUE; } 
//  static Boolean isComponent(VkComponent *component);  I don't know if this will work, or even if it's necessary

    static const char *const deleteCallback;
};

#endif /* VKCOMPONENT_H */
