/**
 *
 * $Id: VkMenuConfirmFirstAction.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition of menu actions
 * that require user confirmation before execution.  This
 * allows the programmer to easily determine whether the
 * user wants a (possibly) dangerous or irreversible action
 * to take place.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKMENUCONFIRMFIRSTACTION_H
#define VKMENUCONFIRMFIRSTACTION_H

#include <Xm/PushBG.h>
#include <Vk/VkConfig.h>
#include <Vk/VkMenuAction.h>

class VkMenuConfirmFirstAction : public VkMenuAction {
private:
  static void _confirmCallback(Widget, XtPointer, XtPointer);
public:
  VkMenuConfirmFirstAction(char *name);

  VkMenuItemType menuType();

  void _instantiate(Widget parent);

  const char *className();

  Boolean isContainer();
};

#endif // VKMENUCONFIRMFIRSTACTION_H

