/**
 *
 * $Id: VkPopupMenu.h,v 1.3 1995/04/20 05:32:07 toshok Exp $
 *
 *
 * This file contains the class definition for VkPopup menus.
 * These menus allow the programmer to specify which menu should 
 * pop up over which widgets, when the user hits the right mouse button.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKPOPUPMENU_H
#define VKPOPUPMENU_H

#include <X11/Intrinsic.h>
#include <Xm/RowColumn.h>
#include <Vk/VkConfig.h>
#include <Vk/VkMenu.h>

class VkPopupMenu : public VkMenu {
private:
  static void _popup(Widget w,
		     XtPointer clientData,
		     XEvent *event,
		     Boolean *);  
public:
  VkPopupMenu(VkMenuDesc *menuDesc,
 	      XtPointer defaultClientData = NULL);
  
  VkPopupMenu(const char *name = "popupMenu",
 	      VkMenuDesc *menuDesc = NULL,
 	      XtPointer defaultClientData = NULL);
  
  VkPopupMenu(Widget parent,
	      VkMenuDesc *menuDesc = NULL,
	      XtPointer defaultClientData = NULL);
  
  VkPopupMenu(Widget parent,
	      const char *name = "popupMenu",
	      VkMenuDesc *menuDesc = NULL,
	      XtPointer defaultClientData = NULL);
  
  virtual void attach(Widget w);
  
  virtual void build(Widget parent);
 
  virtual void show(); 
  virtual void show(XEvent *buttonPressEvent);
  
  VkMenuItemType menuType();
  
  Boolean isContainer();
  
  const char *className();
  
  void setLabel(const char *str);
  
  void _instantiate(Widget parent);
};

#endif // VKPOPUPMENU_H
