/**
 *
 * $Id: VkRadioGroup.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for
 * the VkRadioGroup class, which allows programmers
 * to enforce radio-like behavior on toggle buttons
 * and pushbuttons which inhabit different parts
 * of the interface (that is, are not children of the
 * same RowColumn).
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKRADIOGROUP_H
#define VKRADIOGROUP_H

#include <Vk/VkConfig.h>
#include <Vk/VkWidgetList.h>

class VkRadioGroup : public VkWidgetList {
private:
  int currentlySelected;

  void changeAppearance(int selection);
  static void changeAppearanceCallback(Widget, XtPointer, XtPointer);

public:
  VkRadioGroup();

  virtual void add(Widget item);
  virtual void add(VkComponent *component);

  virtual void remove(Widget item);
  virtual void remove(VkComponent *component);

  virtual void removeFirst();
  virtual void removeLast();
};

#endif // VKRADIOGROUP_H
