/**
 *
 * $Id: VkCallbackList.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for callback
 * lists, which is an internally used class that helps
 * clear up the VkCallbackObject class code.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc. 
 * All Rights Reserved
 *
 **/

#ifndef VKCALLBACKLIST_H
#define VKCALLBACKLIST_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Vk/VkCallbackObject.h>

typedef struct {
    enum CallbackType type;
    VkCallbackObject *component;
    VkCallbackFunction callbackFunction;
    VkCallbackMethod callbackMemberFunction;
    void *clientData;
} VkCallbackListEntry;

class VkCallbackList {
private:
    int _numberOfCallbacks;
    int _maxNumberOfCallbacks;
    char *_name;

    VkCallbackListEntry *callbacks;

public:
    VkCallbackList(const char *name);

    void addMemberFunction(VkCallbackObject *component,
			   VkCallbackMethod callbackMember,
			   void *clientData);

    
    void removeMemberFunction(VkCallbackObject *otherObject,
			      VkCallbackMethod memberFunction,
			      void *clientData);

    void addCStyleFunction(VkCallbackFunction callbackFunction,
			   void *clientData);

    void removeCStyleFunction(VkCallbackFunction callbackFunction,
			      void *clientData);

    void removeAllMethods(VkCallbackObject *fromObj);

    void removeAll();

    void call(VkCallbackObject *caller, void *callData);

    char *name() const { return _name;};

    int number() { return _numberOfCallbacks;};
};

#endif // VKCALLBACKLIST_H
