/**
 *
 * $Id: VkCursorList.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the VkCursorList class,
 * an aid in creating animated cursors for busy times in the application.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKCURSORLIST_H
#define VKCURSORLIST_H

#include <Vk/VkConfig.h>
#include <X11/Xlib.h>

class VkCursorList {
public:
  VkCursorList (int numCursors);
  virtual void createCursor(int index) = 0;
  int numCursors();
  Cursor operator[] (int index) const;
  int index();
  void progress();
protected:
  Pixmap *_cursorList;
private:
  int _numCursors;
  int _currentIndex;
};

#endif // VKCURSORLIST_H
