/**
 *
 * $Id: VkDialogManager.h,v 1.9 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the C++ class definition for the abstract class
 * of dialog managers, from which all other dialog managers are
 * derived.  The user shood have no need to make use of this class,
 * except to derive new instances of dialog from it.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKDIALOGMANAGER_H
#define VKDIALOGMANAGER_H

#include <Xm/Xm.h>
#include <Xm/MessageB.h>
#include <Xm/SelectioB.h>
#include <Xm/DialogS.h>
#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Vk/VkResource.h>
#include <Vk/VkSimpleWindow.h>

class VkDialogManager : public VkComponent {
public:
    typedef enum {OK, APPLY, CANCEL} VkDialogReason;

private:
    /* stuff needed for our own event loop */
    Boolean done_with_event_loop;

    /* stuff for managing the list of dialogs */
    Widget _getDialog(Widget parent);
    int _cachedDialogFor(Widget parent);
    void _addDialog(Widget parent, Widget dialog);
    int number_of_dialogs_cached;
    int max_number_of_dialogs_cached;
    Widget *dialogs;
    Widget *parents;

    Boolean _centered;

    /* callback functions for when buttons get pressed */
    static void _dialogBoxOK(Widget, XtPointer, XtPointer);
    static void _dialogBoxCANCEL(Widget, XtPointer, XtPointer);
    static void _dialogBoxAPPLY(Widget, XtPointer, XtPointer);

    void setupWindowManagerProperties(Widget dialog);
    static void handle_wm(Widget, XtPointer, XtPointer);

    char *_okLabel, *_cancelLabel, *_applyLabel;

protected:
    virtual Widget prepost(const char *msg,
			   XtCallbackProc okCB = NULL,
			   XtCallbackProc cancelCB = NULL,
			   XtCallbackProc applyCB = NULL,
			   XtPointer clientData = NULL,
			   const char *helpString = NULL,
			   VkSimpleWindow *parent = NULL);
    
    Widget prepost(const char *msg,
		   const char *helpString,
		   VkSimpleWindow *parent) { return prepost(msg, NULL, NULL, NULL, NULL, helpString, parent);}

    String  _dialogShellTitle;
    Boolean _okButton;
    Boolean _cancelButton;
    Boolean _applyButton;
    Boolean _helpButton;
    VkDialogReason _action;

    Boolean _allowMultipleDialogs;

    /* the constructor is protected simply because it is _never_
       called by anything other than a subclass */

    VkDialogManager(const char *name);

    /* common interface to Xm...GetChild(), at least for the OK/CANCEL/APPLY buttons */
    Widget GetChildButton(Widget w, unsigned int child);

    /* this method must be overloaded in subclasses to create the actual dialog box */
    virtual Widget createDialog(Widget parent) = 0;

    virtual void ok(Widget dialog, XtPointer) {unpost(dialog);};
    virtual void cancel(Widget dialog, XtPointer) {unpost(dialog);};
    virtual void apply(Widget dialog, XtPointer) {/* do nothing */};

public:
    // posting non-modal dialogs.

    virtual Widget post (const char *msg = NULL,
			 XtCallbackProc okCB = NULL,
			 XtCallbackProc cancelCB = NULL,
			 XtCallbackProc applyCB = NULL,
			 XtPointer clientData = NULL,
			 const char *helpString = NULL,
			 VkSimpleWindow *parent = NULL,
			 Widget *parentWidget = NULL);

    Widget post (const char *msg,
		 VkSimpleWindow *parent);

    Widget post (const char *msg,
		 const char *helpString,
		 VkSimpleWindow *parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtPointer clientData,
		 VkSimpleWindow *parent = NULL);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtPointer clientData,
		 const char *helpString,
		 VkSimpleWindow *parent = NULL);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtCallbackProc cancelCB,
		 XtPointer clientData,
		 char *helpString,
		 VkSimpleWindow *parent = NULL);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtCallbackProc cancelCB,
		 XtCallbackProc applyCB,
		 XtPointer clientData,
		 VkSimpleWindow *parent);

    Widget post (const char *msg,
		 Widget parent);

    Widget post (const char *msg,
		 const char *helpString,
		 Widget parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtPointer clientData,
		 Widget parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtPointer clientData,
		 const char *helpString,
		 Widget parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtCallbackProc cancelCB,
		 XtPointer clientData,
		 Widget parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtCallbackProc cancelCB,
		 XtPointer clientData,
		 char *helpString,
		 Widget parent);

    Widget post (const char *msg,
		 XtCallbackProc okCB,
		 XtCallbackProc cancelCB,
		 XtCallbackProc applyCB,
		 XtPointer clientData,
		 Widget parent);

    // posting modal dialogs

    virtual Widget postModal(const char *msg = NULL,
			     XtCallbackProc okCB = NULL,
			     XtCallbackProc cancelCB = NULL,
			     XtCallbackProc applyCB = NULL,
			     XtPointer clientData = NULL,
			     const char *helpString = NULL,
			     VkSimpleWindow *parent = NULL,
			     Widget *parentWidget = NULL);

    Widget postModal (const char *msg,
		      VkSimpleWindow *parent);

    Widget postModal (const char *msg,
		      const char *helpString,
		      VkSimpleWindow *parent);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtPointer clientData,
		      VkSimpleWindow *parent = NULL);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtPointer clientData,
		      const char *helpString,
		      VkSimpleWindow *parent = NULL);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtPointer clientData,
		      VkSimpleWindow *parent = NULL);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtPointer clientData,
		      char *helpString,
		      VkSimpleWindow *parent = NULL);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtCallbackProc applyCB,
		      XtPointer clientData,
		      VkSimpleWindow *parent);

    Widget postModal (const char *msg,
		      Widget parent);
    
    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtPointer clientData,
		      Widget parent);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtPointer clientData,
		      const char *helpString,
		      Widget parent);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtPointer clientData,
		      Widget parent);

    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtPointer clientData,
		      char *helpString,
		      Widget parent);
    
    Widget postModal (const char *msg,
		      XtCallbackProc okCB,
		      XtCallbackProc cancelCB,
		      XtCallbackProc applyCB,
		      XtPointer clientData,
		      Widget parent);

    virtual Widget postBlocked(const char *msg = NULL,
			       XtCallbackProc okCB = NULL,
			       XtCallbackProc cancelCB = NULL,
			       XtCallbackProc applyCB = NULL,
			       XtPointer clientData = NULL,
			       const char *helpString = NULL,
			       VkSimpleWindow *parent = NULL,
			       Widget *parentWidget = NULL);


    virtual Widget postBlocked(const char *msg, 
                               VkSimpleWindow *parent);

    Widget postBlocked (const char *msg,
			const char *helpString,
			VkSimpleWindow *parent);

    Widget postBlocked (const char *msg,
			XtCallbackProc okCB,
			XtPointer clientData,
			VkSimpleWindow *parent = NULL);

    Widget postBlocked (const char *msg,
			XtCallbackProc okCB,
			XtPointer clientData,
			const char *helpString,
			VkSimpleWindow *parent = NULL);

    Widget postBlocked (const char *msg,
			XtCallbackProc okCB,
			XtCallbackProc cancelCB,
			XtPointer clientData,
			VkSimpleWindow *parent = NULL);

    Widget postBlocked (const char *msg,
			XtCallbackProc okCB,
			XtCallbackProc cancelCB,
			XtPointer clientData,
			char *helpString,
			VkSimpleWindow *parent = NULL);

    Widget postBlocked (const char *msg,
			XtCallbackProc okCB,
			XtCallbackProc cancelCB,
			XtCallbackProc applyCB,
			XtPointer clientData,
			VkSimpleWindow *parent);

    virtual VkDialogReason postAndWait(const char *msg = NULL,
				       Boolean ok = TRUE,
				       Boolean cancel = TRUE,
				       Boolean apply = FALSE,
				       const char *helpString = NULL,
				       VkSimpleWindow *parent = NULL,
				       Widget *parentWidget = NULL);


    VkDialogReason postAndWait (const char *msg,
				const char *helpString,
				VkSimpleWindow *parent = NULL);

    VkDialogReason postAndWait (const char *msg,
				VkSimpleWindow *parent);

    virtual const char *className() = 0;

    void setTitle (const char *nextTitle = NULL);
    void setButtonLabels(const char *okLabel = NULL,
                         const char *cancelLabel = NULL,
                         const char *applyLabel = NULL);

    void centerOnScreen(Boolean flag);

    Widget lastPosted();

    void unpost();
    void unpost(Widget w);
    void unpostAll();
};


#endif /* VKDIALOGMANAGER_H */
