/**
 *
 * $Id: VkGangedGroup.h,v 1.2 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration
 * for the VkGangedGroup class, which allows the
 * programmer to keep a group of scrollbars or
 * scales at the same value, meaning if you update
 * one, they are all updated.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved
 *
 **/

#ifndef VKGANGEDGROUP_H
#define VKGANGEDGROUP_H

#include <Vk/VkConfig.h>
#include <Vk/VkWidgetList.h>

class VkGangedGroup : public VkWidgetList {
private:
  void _change(int value);
  static void _changeCallback(Widget, XtPointer, XtPointer);

public:
  VkGangedGroup();

  virtual void add(Widget w);
  virtual void add(VkComponent *obj);

  virtual void remove(Widget w);
  virtual void remove(VkComponent *obj);

  virtual void removeFirst();
  virtual void removeLast();
};

#endif // VKGANGEDGROUP_H
