/**
 *
 * $Id: VkHelpPane.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the VkHelpPane class,
 * which allows the programmer to easily add help menu items to
 * the application.
 * 
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKHELPPANE_H
#define VKHELPPANE_H

#include <Xm/RowColumn.h>
#include <Xm/CascadeBG.h>
#include <Vk/VkConfig.h>
#include <Vk/VkSubMenu.h>

class VkHelpPane : public VkSubMenu {
private:
    Cursor helpCursor;

    static const String defaultResourceSpec[];

    Widget isParentAShell();

    void showVersion();
    void clickForHelp();
    void overview();
    void index();
    void keys();

    static void showVersionCallback(Widget, XtPointer, XtPointer);
    static void clickForHelpCallback(Widget, XtPointer, XtPointer);
    static void overviewCallback(Widget, XtPointer, XtPointer);
    static void indexCallback(Widget, XtPointer, XtPointer);
    static void keysCallback(Widget, XtPointer, XtPointer);

public:
    VkHelpPane(const char *name = "helpMenu",
	       VkMenuDesc *desc = NULL,
	       XtPointer defaultClientData = NULL);
    
    VkHelpPane(Widget parent,
	       const char *name = "helpMenu",
	       VkMenuDesc *desc = NULL,
	       XtPointer defaultClientData = NULL);
    
    virtual ~VkHelpPane();
    
    const char *className();
    
    void _instantiate(Widget parent);
  
};

#endif // VKHELPPANE_H
