/**
 *
 * $Id: VkMenu.h,v 1.3 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the c++ class definition for the
 * abstract class VkMenu.  This class forms the basis
 * for many of the menus that can be instantiated in
 * user applications, and offers an array of generic
 * operations allowed in all of its subclasses.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKMENU_H
#define VKMENU_H

#include <Vk/VkConfig.h>
#include <Vk/VkMenuItem.h>

class VkWindow;
class VkMenuAction;
class VkMenuConfirmFirstAction;
class VkMenuLabel;
class VkMenuSeparator;
class VkMenuToggle;
class VkSubMenu;
class VkRadioSubMenu;

typedef struct VkMenuDesc VkMenuDesc;

struct VkMenuDesc {
  VkMenuItemType menuType;
  char *name;
  XtCallbackProc callback;
  VkMenuDesc *submenu;
  XtPointer clientData;
  XtCallbackProc undoCallback;
};

class VkMenu : public VkMenuItem {  // ABSTRACT CLASS

friend VkMenuItem;
friend VkSubMenu;
  
protected:
  int numberOfElements;
  int maxNumberOfElements;
  XtPointer _defaultClientData;
  VkMenuItem **elements;

public:
  VkMenu(const char *name);
  
  VkMenuAction *addAction(const char *name,
 			  XtCallbackProc actionCallback = NULL,
 			  XtPointer clientData = NULL,
 			  int position = -1);
  VkMenuAction *addAction(const char *name,
 			  XtCallbackProc actionCallback,
 			  XtCallbackProc undoCallback,
 			  XtPointer clientData,
 			  int position = -1);
  
  VkMenuConfirmFirstAction *addConfirmFirstAction(const char *name,
 						  XtCallbackProc actionCallback = NULL,
 						  XtPointer clientData = NULL,
 						  int position = -1);
  
  VkMenuToggle *addToggle(const char *name,
 			  XtCallbackProc actionCallback = NULL,
 			  XtPointer clientData = NULL,
 			  int state = -1,
 			  int position = -1);
  
  VkMenuLabel *addLabel(const char *name,
 			int position  = -1);
  
  VkMenuSeparator *addSeparator(const char *name = "separator",
 				int position = -1);
  
  VkSubMenu *addSubmenu(VkSubMenu *submenu,
			int position = -1);
  
  VkSubMenu *addSubmenu (const char *name,
 			 int position = -1);
  
  VkSubMenu *addSubmenu(const char *name,
 			VkMenuDesc *menuDesc,
 			XtPointer defaultClientData = NULL,
 			int position = -1);
  
  VkRadioSubMenu *addRadioSubmenu(VkRadioSubMenu *submenu,
 				  int position = -1);
  
  VkRadioSubMenu *addRadioSubmenu(const char *name,
 				  int position = -1);
  
  VkRadioSubMenu *addRadioSubmenu(const char *name,
 				  VkMenuDesc *menuDesc,
 				  XtPointer defaultClientData = NULL,
 				  int position = -1);
  
  void add(VkMenuItem *item,
 	   int position = -1);
  
  VkMenuItem *findNamedItem(const char *name,
 			    Boolean caseless = FALSE);
  
  VkMenuItem *activateItem(const char *name);
  
  VkMenuItem *deactivateItem(const char *name);
  
  VkMenuItem *removeItem(const char *name);
  
  VkMenuItem *replace(const char *name, VkMenuItem *newItem);
  
  int numItems() const;
  
  int getItemPosition(VkMenuItem *item);
  int getItemPosition(char *name);
  int getItemPosition(Widget w);
  
  virtual operator _WidgetRec*() const;
  VkMenuItem *operator[] (int index) const;

  virtual const char *className();
};

#endif // VKMENU_H

