/**
 *
 * $Id: VkMenuUndoManager.h,v 1.3 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class declaration for
 * the undo manager.  The programmer registers
 * actions with this manager, and the manager
 * provides the mechanism for the user of the
 * program to undo the action.
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc.
 * All Rights Reserved.
 *
 **/

#ifndef VKMENUUNDOMANAGER_H
#define VKMENUUNDOMANAGER_H

#include <Vk/VkConfig.h>
#include <Vk/VkMenuAction.h>
#include <Vk/VkComponentList.h>

class VkAction;

class VkMenuUndoManager : public VkMenuAction {
friend class VkAction;

private:
    VkComponentList *_history;
    Boolean _isMultiLevel;

    void registerAction(VkAction *);
    void registerAction(VkMenuAction *);

public:
    VkMenuUndoManager(char *name);

    const char *className() { return "VkMenuUndoManager";};

    void add(const char *name, 
	     XtCallbackProc undoCallback,
	     XtPointer clientData);

    VkComponentList *historyList();
    void reset();

    void multiLevel(Boolean flag);

    Boolean isContainer() {return False;};
    VkMenuItemType menuType() { return ACTION; };
    
    void _instantiate(Widget parent);
};

extern VkMenuUndoManager *_theMenuUndoManager;

#define theUndoManager _theMenuUndoManager

#endif // VKMENUUNDOMANAGER_H
