/**
 *
 * $Id: VkSimpleWindow.h,v 1.4 1995/04/20 05:32:07 toshok Exp $
 *
 * This file contains the class definition for the VkSimpleWindow class.
 * This class is used for simple window stuff (I guess :)).
 *
 * Chris Toshok
 * Copyright (C) 1995
 * The Hungry Programmers, Inc
 * All Rights Reserved
 *
 **/

#ifndef VKSIMPLEWINDOW_H
#define VKSIMPLEWINDOW_H

#include <Vk/VkConfig.h>
#include <Vk/VkComponent.h>
#include <Xm/MainW.h>

typedef enum {OPEN, CLOSED, ICON_UNKNOWN} IconState;
typedef enum {VISIBLE, HIDDEN, VISIBLE_UNKNOWN} VisibleState;
typedef enum {RAISED, LOWERED, STACKING_UNKNOWN} StackingState;

class VkSimpleWindow : public VkComponent {

private:
    char *_windowTitle;
    char *_iconName;

    static void wm_delete_window(Widget, XtPointer, XtPointer);
    static void wm_quit_app(Widget, XtPointer, XtPointer);
    static void change_state_handler(Widget w, XtPointer clientData, XEvent *event, Boolean *);

    void changeState(XEvent *event);

protected:
    Widget _currentView;
    IconState _iconState;
    VisibleState _visibleState;
    StackingState _stackingState;
    Widget _mainWindowWidget;
  
public:
    VkSimpleWindow(const char *name,
		   ArgList args = NULL,
		   Cardinal argCount = 0);

    virtual ~VkSimpleWindow();

    virtual const char *className();
  
    virtual Widget setUpInterface(Widget) { return (Widget)NULL; };

    void addView(Widget w);
    void addView(VkComponent *component);
    void removeView();

    virtual void show();
    virtual void hide();
    virtual void iconify();
    virtual void open();
    virtual void raise();
    virtual void lower();

// Window Data Access  Functions

    virtual Widget mainWindowWidget() const;
    virtual Widget viewWidget() const;
    Boolean visible() const;
    Boolean iconic() const;

// Window Manager Stuff
  
    void setTitle(const char *newTitle);
    const char *getTitle();
    void setIconName(const char *newTitle);

// This doesn't exist in SGI's vk, but it was easy.
    void setIconPixmap(Pixmap pix);

// Properties and Shell Resources

    virtual void handleWMDeleteMessage();
    virtual void handleWMQuitMessage();

//    void setClassHint(const char *className);
    virtual void setUpWindowProperties();

    virtual void stateChanged(IconState newState);
    virtual void afterRealizeHook();
    virtual void handleRawEvent(XEvent *event);
};

#endif /* VKSIMPLEWINDOW_H */

