"""
ldapoidreg - Simple dictionary registry for LDAP-related OIDs.

Comprehensive list contributed by
Norbert Klasen <norbert.klasen@zdv.uni-tuebingen.de>
"""

oid = {

  #controls
  "1.2.826.0.1.3344810.2.3":(
    "valuesReturnFilter",
    "",
    "draft-ietf-ldapext-matchedval"),
  "1.2.840.113549.6.0.0":( 
    "Signed Operation",
    "",
    "RFC2649"),
  "1.2.840.113549.6.0.1":( 
    "Demand Signed Result",
    "",
    "RFC2649"),
  "1.2.840.113549.6.0.2":( 
    "Signed Result",
    "",
    "RFC2649"),
  "1.2.840.113556.1.4.319":( 
    "paged Results",
    "",
    "RFC2696"),
  "1.2.840.113556.1.4.417":( 
    "SHOW_DELETED",
    "The LDAP_SERVER_NOTIFICATION_OID control is used with an extended LDAP asynchronous search function to register the client to be notified when changes are made to an object in the Active Directory",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.473":( 
    "Sort Key Request",
    "",
    "RFC2891"),
  "1.2.840.113556.1.4.474":( 
    "Sort Key Response",
    "",
    "RFC2891"),
  "1.2.840.113556.1.4.521":( 
    "CROSSDOM_MOVE_TARGET",
    "The LDAP_SERVER_CROSSDOM_MOVE_TARGET_OID control is used with an extended LDAP rename function to move an LDAP object from one domain to another.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.528":( 
    "NOTIFICATION",
    "The LDAP_SERVER_NOTIFICATION_OID control is used with an extended LDAP asynchronous search function to register the client to be notified when changes are made to an object in the Active Directory",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.529":( 
    "EXTENDED_DN",
    "The LDAP_SERVER_EXTENDED_DN_OID control is used with an extended LDAP search function to request an extended form of an Active Directory object's distinguished name. The extended form includes a string representation of the object's objectGUID property. For security principal objects such as users, groups, and computers, the extended form also includes a string representation of the object's objectSID property.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.619":( 
    "LAZY_COMMIT",
    "The LDAP_SERVER_LAZY_COMMIT_OID control is used to tell the server to return the results of a DS modification command, such as add, delete, replace, etc., after it has been completed in memory, but before it has been committed to disk. The server can then return results quickly, and take more time to actually save the data to disk without holding up the client.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.801":( 
    "SD_FLAGS",
    "The LDAP_SERVER_SD_FLAGS_OID control is used to pass flags to the server to control various security desciptor behaviors.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.805":( 
    "TREE_DELETE",
    "The LDAP_SERVER_TREE_DELETE_OID control is used with an extended LDAP delete function to delete an entire subtree in the directory.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.841":( 
    "DIRSYNC",
    "The LDAP_SERVER_DIRSYNC_OID control allows the application to search the directory for objects that have changed since a previous state, and is used with the extended LDAP search functions such as ldap_search_ext.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.1338":( 
    "VERIFY_NAME",
    "The LDAP_SERVER_VERIFY_NAME_OID control is used with an extended LDAP search function to specify a specific GC on which to perform the search for an object. This is useful when adding a DN valued attribute. If the object that the DN points to has recently been created, the DC may not be able to verify the existence of the object on it's own. This control can be used to tell the DC about a specific GC that can verify the existence of the object for it.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.1339":( 
    "DOMAIN_SCOPE",
    "The LDAP_SERVER_DOMAIN_SCOPE_OID control is used to tell the LDAP server not to generate any referrals when completing a request. This control also limits any search using it to a single naming context.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.1340":( 
    "SEARCH_OPTIONS",
    "The LDAP_SERVER_SEARCH_OPTIONS_OID control is used to pass flags to the server to control various search behaviors.",
    "Microsoft Platform SDK"),
  "1.2.840.113556.1.4.1413":( 
    "PERMISSIVE_MODIFY",
    "The LDAP_SERVER_PERMISSIVE_MODIFY_OID control is used to modify the behavior of an extended LDAP modify request such as ldap_modify_ext. An LDAP modify request will normally fail if it attempts to add an attribute that already exists, or if it attempts to delete an attribute that does not exist. With this control, as long as the attribute to be added has the same value as the existing attribute, then the modify will succeed. With this control, deletion of an attribute that doesn't exist will also succeed.",
    "Microsoft Platform SDK"),
  "1.3.6.1.4.1.1466.29539.1":( 
    "LDAP_CONTROL_ATTR_SIZELIMIT",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.2":( 
    "LDAP_CONTROL_NO_COPY",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.3":( 
    "LDAP_CONTROL_PARTIAL_COPY",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.5":( 
    "LDAP_CONTROL_NO_CHAINING",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.7":( 
    "LDAP_CONTROL_ALIAS_ON_UPDATE",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.10":( 
    "LDAP_CONTROL_TRIGGER",
    "",
    ""),
  "1.3.6.1.4.1.1466.29539.12":( 
    "nsTransmittedControl",
    "Control included with iPlanet Directory Server prevents loops.",
    "iPlanet Directory Server 5.0 Administrator's Guide"),

  # Syntegra X.500 controls
  # see http://www.openldap.org/lists/ietf-ldapext/200010/msg00127.html
  "2.16.840.1.113531.18.2.1":(
    "LDAP_C_SETOPTIONS_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.2":(
    "LDAP_C_SETDONTUSECOPY_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.3":(
    "LDAP_C_SETLOCALSCOPE_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.4":(
    "LDAP_C_SETOPERATTR_OID",
    "Return operational attributes as well as user attributes",
    ""),
  "2.16.840.1.113531.18.2.5":(
    "LDAP_C_SETSUBENTRIES_OID",
    "Return only subentries",
    ""),
  "2.16.840.1.113531.18.2.6":(
    "LDAP_C_SETUSEALIAS_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.7":(
    "LDAP_C_SETPREFERCHAIN_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.8":(
    "LDAP_C_SETX500DN_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.9":(
    "LDAP_C_SETCOPYSHALLDO_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.10":(
    "LDAP_C_SETDONTMAPATTRS_OID",
    "",
    ""),
  "2.16.840.1.113531.18.2.11":(
    "LDAP_C_SETALLENTRIES_OID",
    "Return normal entries as well as sub-entries",
    ""),

  "2.16.840.1.113719.1.27.101.1":( 
    "Duplicate Entry Request",
    "",
    "draft-ietf-ldapext-ldapv3-dupent"),
  "2.16.840.1.113719.1.27.101.2":( 
    "DuplicateSearchResult",
    "",
    "draft-ietf-ldapext-ldapv3-dupent"),
  "2.16.840.1.113719.1.27.101.3":( 
    "DuplicateEntryResponseDone",
    "",
    "draft-ietf-ldapext-ldapv3-dupent"),
  "2.16.840.1.113730.3.4.2":( 
    "ManageDsaIT",
    "",
    "draft-zeilenga-ldap-namedref"),
  "2.16.840.1.113730.3.4.3":( 
    "Persistent Search",
    "",
    "draft-ietf-ldapext-psearch"),
  "2.16.840.1.113730.3.4.4":( 
    "Netscape Password Expired",
    "",
    "vchu-ldap-pwd-policy-00"),
  "2.16.840.1.113730.3.4.5":( 
    "Netscape Password Expiring",
    "an octet string to indicate the time in seconds until the password expires",
    "vchu-ldap-pwd-policy-00"),
  "2.16.840.1.113730.3.4.6":( 
    "Netscape NT Synchronization Client",
    "",
    ""),
  "2.16.840.1.113730.3.4.7":( 
    "Entry Change Notification",
    "This control provides additional information about the change the caused a particular entry to be returned as the result of a persistent search.",
    "draft-ietf-ldapext-psearch"),
  "2.16.840.1.113730.3.4.9":( 
    "Virtual List View Request",
    "",
    "draft-ietf-ldapext-ldapv3-vlv"),
  "2.16.840.1.113730.3.4.10":( 
    "Virtual List View Response",
    "",
    "draft-ietf-ldapext-ldapv3-vlv"),
  "2.16.840.1.113730.3.4.11":( 
    "Transaction ID Response",
    "",
    "http://docs.iplanet.com/docs/manuals/directory.html"),
  "2.16.840.1.113730.3.4.12":( 
    "Proxied Authorization",
    "allows LDAP clients to use different credentials, without rebinding, when executing LDAP operations.",
    "draft-weltman-ldapv3-proxy"),
  "2.16.840.1.113730.3.4.13":( 
    "iPlanet Directory Server Replication Update Information",
    "",
    " http://docs.iplanet.com/docs/manuals/directory.html"),
  "2.16.840.1.113730.3.4.14":( 
    "iPlanet Directory Server search on specific backend",
    "",
    "http://docs.iplanet.com/docs/manuals/directory.html"),
  "2.16.840.1.113730.3.4.15":( 
    "Authentication Response",
    "Returned with bind requests to provide LDAP clients with the DN and authentication method used (useful when SASL or certificate mapping is employed).",
    "draft-weltman-ldapv3-auth-response-03.txt"),
  "2.16.840.1.113730.3.4.16":( 
    "Authentication Request",
    "Can be provided with bind requests to indicate to the server that an Authentication Response Control is desired with the bind response.",
    "draft-weltman-ldapv3-auth-response-03.txt"),
  "2.16.840.1.113730.3.4.17":( 
    "Real Attributes Only",
    "This control requests that the server only return attributes which are truly contained in the entries returned and that no resolution of virtual attributes be performed (such as defined by class of service and roles).",
    "http://docs.iplanet.com/docs/manuals/directory.html "),
  "2.16.840.1.113730.3.4.18":( 
    "Proxied Authorization (version 2)",
    "For assuming the identity of another entry for the duration of a request.",
    "draft-weltman-ldapv3-proxy-06.txt"),

  #extops
  "2.16.840.1.113719.1.142.100.1":( 
    "StartFramedProtocolRequest",
    "",
    "draft-ietf-ldup-framing"),
  "2.16.840.1.113719.1.142.100.2":( 
    "StartFramedProtocolResponse",
    "",
    "draft-ietf-ldup-framing"),
  "2.16.840.1.113719.1.142.100.3":( 
    "ReplicationUpdate",
    "",
    "draft-ietf-ldup-protocol"),
  "2.16.840.1.113719.1.142.100.4":( 
    "EndFramedProtocolRequest",
    "",
    "draft-ietf-ldup-framing"),
  "2.16.840.1.113719.1.142.100.5":( 
    "EndFramedProtocolResponse",
    "",
    "draft-ietf-ldup-framing"),
  "1.3.6.1.4.1.1466.101.119.1":( 
    "Dynamic Directory Services Refresh Request",
    "",
    "RFC2589"),
  "1.3.6.1.4.1.1466.20037":( 
    "Start TLS",
    "",
    "RFC2830"),
  "1.3.6.1.4.1.4203.1.11.1":( 
    "Password Modify",
    "modification of user passwords",
    "RFC3062"),

  #LDAP Server Profiles 
  #attribute: ogSupportedProfile 
  #http://www.opengroup.org/orc/DOCS/LDAP_PR/text/apdxa.htm
  "1.2.826.0.1050.11.1.1":(
    "Read-Only LDAP Server",
    "",
    "Open Group LDAP Server Profiles"),
  "1.2.826.0.1050.11.2.1":(
    "Read-Write LDAP Server",
    "",
    "Open Group LDAP Server Profiles"),
  "1.2.826.0.1050.11.3.1":(
    "White Pages Application LDAP Server",
    "",
    "Open Group LDAP Server Profiles"),
  "1.2.826.0.1050.11.4.1":(
    "Certificate Application LDAP Server",
    "",
    "Open Group LDAP Server Profiles"),
  "1.2.826.0.1050.11.5.1":(
    "Single Sign On Application LDAP Server",
    "",
    "Open Group LDAP Server Profiles"),

  # NDS supports the following LDAP extensions for
  # obtaining effective rights, managing replicas and
  # partitions, and refreshing the LDAP server:
  "2.16.840.1.113719.1.27.100.1":(
    "ndsToLdapResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.2":(
    "ndsToLdapRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.3":(
    "createNamingContextRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.4":(
    "createNamingContextResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.5":(
    "mergeNamingContextRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.6":(
    "mergeNamingContextResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.7":(
    "addReplicaRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.8":(
    "addReplicaResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.9":(
    "refreshLDAPServerRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.10":(
    "refreshLDAPServerResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.11":(
    "removeReplicaRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.12":(
    "removeReplicaResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.13":(
    "namingContextEntryCountRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.14":(
    "namingContextEntryCountResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.15":(
    "changeReplicaTypeRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.16":(
    "changeReplicaTypeResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.17":(
    "getReplicaInfoRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.18":(
    "getReplicaInfoResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.19":(
    "listReplicaRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.20":(
    "listReplicaResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.21":(
    "receiveAllUpdatesRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.22":(
    "receiveAllUpdatesResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.23":(
    "sendAllUpdatesRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.24":(
    "sendAllUpdatesResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.25":(
    "requestNamingContextSyncRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.26":(
    "requestNamingContextSyncResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.27":(
    "requestSchemaSyncRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.28":(
    "requestSchemaSyncResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.29":(
    "abortNamingContextOperationRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.30":(
    "abortNamingContextOperationResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.31":(
    "getContextIdentityNameRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.32":(
    "getContextIdentityNameResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.33":(
    "getEffectivePrivilegesRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.34":(
    "getEffectivePrivilegesResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.35":(
    "setReplicationFilterRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.36":(
    "setReplicationFilterResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.37":(
    "getReplicationFilterRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.38":(
    "getReplicationFilterResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.39":(
    "createOrphanNamingContextRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.40":(
    "createOrphanNamingContextResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.41":(
    "removeOrphanNamingContextRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.42":(
    "removeOrphanNamingContextResponse",
    "",
    "NDS"),

  # Extensions to trigger NDS background processes
  # via ldap_trigger_back_process()
  "2.16.840.1.113719.1.27.100.43":(
    "Trigger Backlinker Request",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.44":(
    "Trigger Backlinker Response",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.47":(
    "Trigger Janitor Request ",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.48":(
    "Trigger Janitor Response",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.49":(
    "Trigger Limber Request ",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.50":(
    "Trigger Limber Response",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.51":(
    "Trigger Skulker Request ",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.52":(
    "Trigger Skulker Response",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.53":(
    "Trigger Schema Synch Request ",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.54":(
    "Trigger Schema Synch Response",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.55":(
    "Trigger Partition Purge Request ",
    "",
    "NDS"),
  "2.16.840.1.113719.1.27.100.56":(
    "Trigger Partition Purge Response",
    "",
    "NDS"),


  # The Novell Import Convert Export utility uses the following
  # extensions.
  "2.16.840.1.113719.1.142.100.1":(
    "startFramedProtocolRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.142.100.2":(
    "startFramedProtocolResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.142.100.4":(
    "endFramedProtocolRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.142.100.5":(
    "endFramedProtocolResponse",
    "",
    "NDS"),
  "2.16.840.1.113719.1.142.100.6":(
    "lburpOperationRequest",
    "",
    "NDS"),
  "2.16.840.1.113719.1.142.100.7":(
    "lburpOperationResponse",
    "",
    "NDS"),

  "1.3.6.1.4.1.4203.1.5.1":(
    "All Operational Attributes",
    "Provide a simple mechanism which clients may use to request the return of all operational attributes.",
    "draft-zeilenga-ldap-opattrs"),

  # The Novell Import Convert Export utility uses the following
  # extensions.
  "2.16.840.1.113730.3.5.3":(
    "iPlanet Start Replication Request Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
  "2.16.840.1.113730.3.5.4":(
    "iPlanet Replication Response Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
  "2.16.840.1.113730.3.5.5":(
    "iPlanet End Replication Request Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
  "2.16.840.1.113730.3.5.6":(
    "iPlanet Replication Entry Request Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
  "2.16.840.1.113730.3.5.7":( 
    "iPlanet Bulk Import Start Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
  "2.16.840.1.113730.3.5.8":(
    "iPlanet Bulk Import Finished Extended Operation",
    "",
    "iPlanet Directory 5.0+"),
}
