"""
web2ldapcnf/misc.py - Misc. configuration options for web2ldap
(c) by Michael Stroeder <michael@stroeder.com>
"""

# Leave this alone
import os,web2ldapcnf

# A list with directories containing additional Python modules
pylibdirs = [os.path.join(web2ldapcnf.web2ldap_dir,'pylib')]

########################################################################
# HTTP-Options
########################################################################

# Integer which defines if UTF-8 is used as character set.
# 0 ISO-8859-1 is used in any case
# 1 if the browser sends utf-8 in Accept-charset header and the web server
# sets HTTP_ACCEPT_CHARSET environment the used character set is
# negotiated. UTF-8 is preferred.
# 2 UTF-8 is always used no matter what the browser sends.
print_rawutf8=2

# The HTTP body can be sent to client gzip-compressed if client presents
# gzip in HTTP_ACCEPT_ENCODING. You can set the gzip level (1-9) here.
# Set 0 to turn it off. This needs zlibmodule which is automatically detected.
# Note: This might speed things up if the server's CPU is very fast
# compared to the network link. Even with large search results you
# won't gain much by choosing gzip level higher than 1.
# Note: Seems to break displaying images in-line in Netscape 4.x.
# Note: Does not work with mod_fastcgi under Apache
gzip_level=0

########################################################################
# Other Options
########################################################################

# Trace output of the LDAP connection can be written to error
# output. Set to non-zero if you want debug your LDAP connection.
# Warning! Passwords (credentials) are written to this trace log!
# If unsure leave zero! Only set to non-zero if you have protected logs!
ldap_trace_level = 0

# Maximum length of LDIF data in the <TEXTAREA> of addform/modifyform
ldif_maxbytes = 200000

# List of URL schemes to process in LDIF input.
# !!! Beware, this can be a security nightmare! Think twice!
# If unsure leave as empty list to ignore all URLs in LDIF.
#ldif_url_schemes = ['file','ftp','http']
ldif_url_schemes = []

# Maximum count of input attribute fields in addform/modifyform
input_maxattrs=1000

# Maximum length of attribute data input fields in addform/modifyform
input_maxfieldlen=1000

# maximum count of search parameters in advanced search form
max_searchparams=9

# Dictionary for defining user-friendly names of attributes types.
ldap_knownattr = {
  'c':'Country',
  'st':'State',
  'l':'Location',
  'o':'Organization',
  'ou':'Organizational Unit',
  'cn':'Common Name',
  'sn':'Surname',
  'givenname':'Given Name',
  'title':'Title',
  'streetaddress':'Street',
  'mail':'E-Mail',
  'uid':'User ID',
  'initials':'Initials',
  'objectclass':'Object Class',
  'telephoneNumber':'Telephone',
  'facsimileTelephoneNumber':'FAX',
  'homePhone':'Home phone',
  'mobile':'Mobile phone',
  'description':'Description'
}

# map binary attributes to MIME-types
ldap_binaryattr = {
    'cACertificate':('CA certificate','application/pkix-cert'),
    'cACertificate;binary':('CA certificate','application/pkix-cert'),
    'crossCertificatePair':('Cross certificate','application/pkix-cert'),
    'crossCertificatePair;binary':('Cross certificate','application/pkix-cert'),
    'authorityRevocationList':('CA CRL','application/pkix-crl'),
    'authorityRevocationList;binary':('CA CRL','application/pkix-crl'),
    'certificateRevocationList':('User CRL','application/pkix-crl'),
    'certificateRevocationList;binary':('User CRL','application/pkix-crl'),
    'deltaRevocationList':('CA CRL','application/pkix-crl'),
    'deltaRevocationList;binary':('CA CRL','application/pkix-crl'),
    'certificate':('Client certificate','application/pkix-cert'),
    'certificate;binary':('Client certificate','application/pkix-cert'),
    'userCertificate':('Client certificate','application/pkix-cert'),
    'userCertificate;binary':('Client certificate','application/pkix-cert'),
    'nDSPKIPublicKeyCertificate':('NDS certificate','application/pkix-cert'),
    'nDSPKICertificateChain':('NDS certificate chain','application/pkix-cert'),
    'entrustPolicyCertificate':('Entrust Policy Certificate','application/pkix-cert'),
    'pem_x509':('Client certificate','application/pkix-cert'),
    'attributeCertificate':('Entrust Attribute Certificate','application/pkix-cert'),
    'fCert':('Client certificate','application/octet-stream'),
    'rCert':('Client certificate','application/octet-stream'),
    'userSMIMECertificate':('S/MIME certificate','application/pkix-cert'),
    'userSMIMECertificate;binary':('S/MIME certificate','application/pkix-cert'),
    'jpegPhoto':('Photograph','image/jpeg'),
    'thumbnailPhoto':('Thumbnail Photograph','image/jpeg'),
    'thumbnailLogo':('Thumbnail Logo','image/jpeg'),
    'photo':('Photograph','image/jpeg'),
    'userPKCS12':('PKCS#12','application/pkcs12'),
    'userPKCS12;binary':('PKCS#12','application/pkcs12'),
    'audio':('Audio','audio/basic'),
    'sASLoginConfigurationKey':('sASLoginConfigurationKey','application/octet-stream'),
  }

# Some browsers are more equal than others ;-)
ldap_browsermimetypes = {
  'Opera': {
    'cACertificate':'application/x-x509-ca-cert',
    'cACertificate;binary':'application/x-x509-ca-cert',
  },
  'Mozilla': {
    'cACertificate':'application/x-x509-ca-cert',
    'cACertificate;binary':'application/x-x509-ca-cert',
    'crossCertificatePair':'application/x-x509-ca-cert',
    'crossCertificatePair;binary':'application/x-x509-ca-cert',
    'authorityRevocationList':'application/x-pkcs7-crl',
    'authorityRevocationList;binary':'application/x-pkcs7-crl',
    'certificateRevocationList':'application/x-pkcs7-crl',
    'certificateRevocationList;binary':'application/x-pkcs7-crl',
    'deltaRevocationList':'application/x-pkcs7-crl',
    'deltaRevocationList;binary':'application/x-pkcs7-crl',
    'certificate':'application/x-x509-email-cert',
    'certificate;binary':'application/x-x509-email-cert',
    'userCertificate':'application/x-x509-email-cert',
    'userCertificate;binary':'application/x-x509-email-cert',
    'pem_x509':'application/x-x509-email-cert',
  },
}

# Path name to dumpasn1.cfg. Grab it from
# http://www.cs.auckland.ac.nz/~pgut001/dumpasn1.cfg
dumpasn1cfg = '/etc/dumpasn1.cfg'

########################################################################
# HTML options
########################################################################

# Additional information in <HEAD></HEAD> section, e.g. CSS.
# Do not put <TITLE> tags in here!
#html_head = r"""
#  <link rel=stylesheet type="text/css" href="http://sites.inka.de/ms/css/web2ldap.css"/>
#"""
html_head = r"""
  <link rel="stylesheet" title="Default" type="text/css" href="/css/web2ldap_default.css">
  <link rel="alternate stylesheet" title="Fixed layout" type="text/css" href="/css/web2ldap_fixed.css">
  <meta name="ROBOTS" content="NOINDEX,NOFOLLOW">
  <script type="text/javascript">
    <!--
     if(top.frames.length > 0)
      top.location.href=self.location;
    //-->
  </script>
"""

# Rudimental configuration for <body>-tag
#html_bodybegin = r"""
#<body link="Red" vlink="Maroon" bgcolor="#fffffe">
#"""
html_bodybegin = r"""
<body>
"""

########################################################################
# Security options
########################################################################

# Amount of time in seconds after which inactive sessions will be expired
# and the user will be prompted for a relogin.
session_relogin = 600

# Amount of time in seconds after which inactive sessions will be expired
# and the session data is removed silently without the possibility to relogin.
session_remove = 6*session_relogin

# List of environment variables assumed to be constant throughout
# web sessions with the same ID if existent.
# These env vars are cross-checked each time when restoring an
# web session to reduce the risk of session-hijacking.
session_checkvars = [
  # REMOTE_ADDR and REMOTE_HOST might not be constant if the client
  # access comes through a network of web proxy siblings.
  'REMOTE_ADDR','REMOTE_HOST',
  'REMOTE_IDENT','REMOTE_USER',
  # If the proxy sets them but can be easily spoofed
  'FORWARDED_FOR','HTTP_X_FORWARDED_FOR',
  # These few are not really secure but better than nothing
  'HTTP_USER_AGENT','HTTP_ACCEPT_CHARSET',
  'HTTP_ACCEPT_ENCODING','HTTP_ACCEPT_LANGUAGE',
  # SSL session ID if running on SSL server capable
  # of reusing SSL sessions
  'SSL_SESSION_ID',
  # env vars of client certs used for SSL strong authentication
  'SSL_CLIENT_V_START','SSL_CLIENT_V_END',
  'SSL_CLIENT_I_DN','SSL_CLIENT_IDN',
  'SSL_CLIENT_S_DN','SSL_CLIENT_SDN',
  'SSL_CLIENT_M_SERIAL','SSL_CLIENT_CERT_SERIAL',
]

# You can set sec_expire to define the amount of
# time (in seconds) the data is valid in the browser
# (HTTP header Expires: is set).
# Note that if you're doing modifications you might get
# a very nasty behaviour if the pages are cached by your browser.
sec_expire = 0

# Specifies a list of the acceptable symmetric key ciphers to
# reach security level 1.
# See also http://www.apache-ssl.org/docs.html and the ApacheSSL
# run-time directives SSLBanCipher, SSLRequireCipher, SSLRequiredCiphers
# Does currently not affect stand-alone mode with SSL.
sec_sslacceptedciphers = [
# Strong ciphers
    'IDEA-CBC-SHA',
    'RC4-MD5',
    'RC4-SHA',
    'IDEA-CBC-MD5',
    'DES-CBC3-SHA',
    'DH-DSS-DES-CBC3-SHA',
    'DH-RSA-DES-CBC3-SHA',
    'EDH-DSS-DES-CBC3-SHA',
    'EDH-RSA-DES-CBC3-SHA',
    'ADH-RC4-MD5',
    'ADH-DES-CBC3-SHA',
    'FZA-RC4-SHA',
    'RC2-CBC-MD5',
    'DES-CBC3-MD5',
# Weak export ciphers
#    'EXP-RC4-MD5',
#    'EXP-RC2-CBC-MD5',
#    'EXP-DES-CBC-SHA',
#    'DES-CBC-SHA',
#    'EXP-DH-DSS-DES-CBC-SHA',
#    'DH-DSS-DES-CBC-SHA',
#    'EXP-DH-RSA-DES-CBC-SHA',
#    'DH-RSA-DES-CBC-SHA',
#    'EXP-EDH-DSS-DES-CBC-SHA',
#    'EDH-DSS-DES-CBC-SHA',
#    'EXP-EDH-RSA-DES-CBC',
#    'EDH-RSA-DES-CBC-SHA',
#    'EXP-ADH-RC4-MD5',
#    'EXP-ADH-DES-CBC-SHA',
#    'ADH-DES-CBC-SHA',
#    'DES-CFB-M1',
#    'DES-CBC-MD5',
#    'RC4-64-MD5'
  ]
