"""
w2lapp.connect.py: present connect dialogue for choosing server

web2ldap - a web-based LDAP Client,
see http://www.web2ldap.de for details

(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)

$Id: connect.py,v 1.11 2002/01/05 22:10:48 michael Exp $
"""

# Modules shipped with web2ldap
import pyweblib.forms,w2lapp.core,w2lapp.gui,w2lapp.cnf

##############################################################################
# Connect form
##############################################################################

def w2l_Connect(outf,command,form,ls,host=None,Msg='New connect'):

  w2lapp.gui.PrintHeader(outf,'Connect',form.accept_charset)

  host_select_list = []
  for host in w2lapp.cnf.hosts.ldap_host_list:
    host_desc = w2lapp.cnf.hosts.ldap_def.get(
      host,
      w2lapp.cnf.hosts.Web2LDAPConfig()
    ).__dict__.get('description','')
    if host_desc:
      host_str = '%s (%s)' % (host,host_desc)
    else:
      host_str = host
    host_select_list.append(
      (
	unicode(host,'iso-8859-1'),
	unicode(host_str,'iso-8859-1')
      )
    )
  if host is None and hasattr(ls,'host'):
    host = ls.host
  elif host_select_list:
    host = host_select_list[0]
  host_select_field = pyweblib.forms.Select(
    'host',u'LDAP Host',1,options=host_select_list,default=host
  )

  outf.write("""
<div id="InputDiv">

  <h1>%s</h1>

  <form 
    action="%s/searchform"
    method="GET" 
    enctype="application/x-www-form-urlencoded"
    accept-charset="%s"
  >
    <fieldset title="Any LDAP host by name:port and a search root">
      <legend>Pre-configured LDAP host(s)</legend>
      <table summary="Host parameters">
        <tr>
          <td>%s</td>
          <td>%s</td>
        </tr>
      </table>
      <input type="submit" value="Connect">
    </fieldset>
  </form>

  <form 
    action="%s/searchform"
    method="GET" 
    enctype="application/x-www-form-urlencoded"
    accept-charset="%s"
  >
    <fieldset title="Any LDAP host by name:port and a search root">
      <legend>Access any LDAP host</legend>
      <table summary="Host parameters">
        <tr>
          <td>%s</td>
          <td>%s</td>
        </tr>
        <tr>
          <td>%s</td>
          <td>%s</td>
        </tr>
      </table>
      <input type="submit" value="Connect">
    </fieldset>
  </form>

</div>

""" % (
    Msg,
    form.script_name,
    form.accept_charset,
    host_select_field.labelHTML('Select host:'),
    host_select_field.inputHTML(),
    form.script_name,
    form.accept_charset,
    form.field['host'].labelHTML('host:port:'),
    form.field['host'].inputHTML(),
    form.field['dn'].labelHTML('search root:<br>(optional)'),
    form.field['dn'].inputHTML(),
  )
)

  w2lapp.gui.PrintFooter(outf,form)
