"""
web2ldapcnf/standalone.py - Options for web2ldap when running stand-alone
(c) by Michael Stroeder <michael@stroeder.com>

Note that these options does not affect CGI-BIN mode at all!
"""

# User account name to setuid after being started as root
run_username = 'nobody'

# Contact mail address of the server admin when running stand-alone
server_admin = 'admin@web2ldap.de'

# Server signature when running stand-alone, HTML snippet,
server_signature = """<ADDRESS>%(SERVER_SOFTWARE)s at
<A HREF="mailto:%(SERVER_ADMIN)s">%(SERVER_NAME)s</A>
Port %(SERVER_PORT)s</ADDRESS>
"""

# List of accepted address/net mask strings of
# accepted client addresses.
# Use ['0.0.0.0/0.0.0.0'] to allow access to every client.
access_allowed = ['127.0.0.1/255.0.0.0','192.168.0.0/255.255.0.0']

########################################################################
# Misc. path names of needed files and directories
########################################################################

# Path name of access log file
access_log = '/var/log/web2ldap/access_log'

# Path name of error log file
error_log = '/var/log/web2ldap/error_log'

# Path name of debug log file
debug_log = '/var/log/web2ldap/debug_log'

# Where static documents reside
document_root = '/usr/local/web2ldap/htdocs/'

# Path name of mime.types file
mime_types = '/usr/local/web2ldap/etc/mime.types'

########################################################################
# SSL-options for running as stand-alone web server
# (these variables have pretty much the same meaning as similar
# named SSL configuration directives in mod_ssl)
########################################################################

# Enable SSL when running stand-alone (might be overriden by option -s)
# Still experimental!
ssl_Engine = 'off'

# Supported protocols (up to now only sslv23 works with Netscape)
#ssl_Protocols = ['tlsv1', 'sslv3', 'sslv2', 'sslv23']
ssl_Protocols = ['sslv23']

# Debug flag
ssl_debug = 'on'

#   Server Certificate:
#   Point SSLCertificateFile at a PEM encoded certificate.  If
#   the certificate is encrypted, then you will be prompted for a
#   pass phrase.
ssl_CertificateFile = '/etc/httpd/ssl.crt/server.crt'

#   Server Private Key:
#   If the key is not combined with the certificate, use this
#   directive to point at the key file.
ssl_CertificateKeyFile = '/etc/httpd/ssl.key/server.key'

#   Certificate Authority (CA):
#   Set the CA certificate verification path where to find CA
#   certificates for client authentication or alternatively one
#   huge file containing all of them (file must be PEM encoded)
#   Note: Inside SSLCACertificatePath you need hash symlinks
#         to point to the certificate files. Use the provided
#         Makefile to update the hash symlinks after changes.
#ssl_CACertificatePath = '/etc/httpd/ssl.crt'
ssl_CACertificateFile = '/etc/httpd/ssl.crt/ca-bundle.crt'

#   Certificate Revocation Lists (CRL):
#   Set the CA revocation path where to find CA CRLs for client
#   authentication or alternatively one huge file containing all
#   of them (file must be PEM encoded)
#   Note: Inside SSLCARevocationPath you need hash symlinks
#         to point to the certificate files. Use the provided
#         Makefile to update the hash symlinks after changes.
ssl_CARevocationPath = '/etc/httpd/ssl.crl'
#ssl_CARevocationFile = '/usr/local/httpd.conf/ssl.crl/ca-bundle.crl'

#   Client Authentication (Type):
#   Client certificate verification type and depth.  Types are
#   none (0), optional (1), require (3).  Depth is a
#   number which specifies how deeply to verify the certificate
#   issuer chain before deciding the certificate is not valid.
ssl_VerifyClient = 0
ssl_VerifyDepth = 10

# File with random data to seed PRNG
# (you won't need that on Linux since /dev/urandom is used there)
#ssl_randfile = '/var/log/messages'
ssl_randfile = ''

