########################################################################
# web2ldap -  web-based LDAP Client, see http://www.web2ldap.de
# (c) by Michael Stroeder <michael@stroeder.com>
########################################################################
# This software is distributed under the terms of the
# GPL (GNU GENERAL PUBLIC LICENSE) Version 2
# (see http://www.gnu.org/copyleft/gpl.html)
########################################################################

import sys,os
from mod_python import apache

if os.name == 'posix':
  # For finding web2ldapcnf.py in /etc/web2ldap on Unix systems
  sys.path.append('/etc/web2ldap')
else:
  # For finding web2ldapcnf.py in system dirs on Windows systems
  for i in ['SystemRoot','windir']:
    if os.environ.has_key(i):
      sys.path.append(os.environ[i])

import web2ldapcnf
sys.path.extend(web2ldapcnf.pylibdirs)

import w2lhandler

def handler(req):
  env, si, so = apache.setup_cgi(req)
  w2lhandler.HandleHTTPRequest(sys.stdin,sys.stdout,os.environ)
  apache.restore_nocgi(env, si, so)
  return apache.OK

