"""
ldapbase.py - class library for LDAP sessions
(c) by Michael Stroeder <michael@stroeder.com>

This module is distributed under the terms of the
GPL (GNU GENERAL PUBLIC LICENSE) Version 2
(see http://www.gnu.org/copyleft/gpl.html)
"""

__version__ = '0.0.2'

import ldap, ldapbase

# Constants for options
OPT_OFF=0
OPT_ON=1

class LDAPSession:

  def __init__(self):
    self.l=None
    self.host=None
    self.dn=None
    self.who=None
    self.cred=None
    self.namingContexts=[]
    self.supportedLDAPVersion=None
    self.subschemaSubentry=None

  def open(self,host='localhost'):
    self.host = host
    self.l = ldap.open(host)
    self.l.set_rebind_proc(None)
    # retrieve Root DSE
#    try:
#      rootDSE=self.l.search_s('',ldap.SCOPE_BASE,'(objectclass=*)',['*'])
#    except ldap.NO_SUCH_OBJECT:
#      pass
#    else:      
#      pass
#      for attrtype in ['namingContexts','subschemaSubentry','supportedLDAPVersion']:
#        setattr(
#          self,
#          attrtype,
#          rootDSE.get(attrtype,rootDSE.get(string.lower(attrtype),None))
#        )

  def set_dn(self,dn):
    """Set current DN"""
    self.dn=ldapbase.normalize(dn)
      
