#!/usr/local/bin/perl
# index.cgi
# Display hosts on which webmin modules are being managed, a list of
# installed modules and a form for installing new ones
# XXX upgrading the entire of webmin
# XXX syncing users and group

require './cluster-webmin-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

# Display hosts on which modules will be installed
print "<h3>$text{'index_hosts'}</h3>\n";
@servers = &list_servers();
@hosts = &list_webmin_hosts();
if ($config{'sort_mode'} == 1) {
	@hosts = sort { my ($as) = grep { $_->{'id'} == $a->{'id'} } @servers;
			my ($bs) = grep { $_->{'id'} == $b->{'id'} } @servers;
			lc($as->{'host'}) cmp lc($bs->{'host'}) } @hosts;
	}
elsif ($config{'sort_mode'} == 2) {
	@hosts = sort { my ($as) = grep { $_->{'id'} == $a->{'id'} } @servers;
			my ($bs) = grep { $_->{'id'} == $b->{'id'} } @servers;
			lc(&server_name($as)) cmp lc(&server_name($bs)) }@hosts;
	}
$formno = 0;
foreach $h (@hosts) {
	local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;
	next if (!$s);
	push(@titles, &server_name($s)."<br>".
		      &text('index_version', $h->{'version'}));
	push(@links, "edit_host.cgi?id=$h->{'id'}");
	push(@icons, "$gconfig{'webprefix'}/servers/images/$s->{'type'}.gif");
	$gothost{$h->{'id'}}++;
	}
if (@links) {
	&icons_table(\@links, \@titles, \@icons);
	}
else {
	print "<b>$text{'index_nohosts'}</b><p>\n";
	}

# Build common selectors
@wgroups = &all_groups(\@hosts);
$modsel2 = $modsel = "<select name=mod>\n";
$modsel2 .= "<option value=''>$text{'index_gacl'}\n";
foreach $m (&all_modules(\@hosts)) {
	$modsel .= "<option value=$m->{'dir'}>$m->{'desc'}\n";
	$modsel2 .= "<option value=$m->{'dir'}>$m->{'desc'}\n";
	}
$modsel .= "</select>\n";
$modsel2 .= "</select>\n";
$themesel = "<select name=theme>\n";
foreach $t (&all_themes(\@hosts)) {
	$themesel .= "<option value=$t->{'dir'}>$t->{'desc'}\n";
	}
$themesel .= "</select>\n";
$usersel = "<select name=user>\n";
foreach $u (&all_users(\@hosts)) {
	$usersel .= "<option>$u->{'name'}\n";
	}
$usersel .= "</select>\n";
$groupsel = "<select name=group>\n";
foreach $u (@wgroups) {
	$groupsel .= "<option>$u->{'name'}\n";
	}
$groupsel .= "</select>\n";

$formno++;
print "<table width=100%><tr>\n";
@addservers = grep { !$gothost{$_->{'id'}} } @servers;
if (@addservers) {
	print "<form action=add.cgi><td>\n";
	print "<input type=submit name=add value='$text{'index_add'}'>\n";
	print "<select name=server>\n";
	foreach $s (@addservers) {
		print "<option value=$s->{'id'}>",&server_name($s),"\n";
		}
	print "</select>\n";
	print "</td></form>\n";
	}
else { print "<td></td>\n"; }

if (@hosts) {
	print "<form action=refresh.cgi><td align=middle>\n";
	print "<input type=submit value='$text{'index_refresh'}'>\n";
	print "</td></form>\n";
	$formno++;
	}
else { print "<td></td>\n"; }

@groups = &servers::list_all_groups(\@servers);
if (@groups) {
	print "<form action=add.cgi><td align=right>\n";
	print "<input type=submit name=gadd value='$text{'index_gadd'}'>\n";
	print "<select name=group>\n";
	foreach $g (@groups) {
		print "<option>$g->{'name'}\n";
		}
	print "</select>\n";
	print "</td></form>\n";
	}
else { print "<td></td>\n"; }
print "</tr></table>\n";

if (@hosts) {
	# Display user search forms and new user buttons
	print "<hr>\n";
	print "<h3>$text{'index_users'}</h3>\n";
	print "<table width=100%>\n";

	print "<tr><form action=edit_user.cgi><td>\n";
	print "<input type=submit value='$text{'index_euser'}'>\n";
	print $usersel;
	print "</td></form>\n";

	print "<form action=edit_acl.cgi><td>\n";
	print "<input type=submit value='$text{'index_euseracl'}'>\n";
	print $usersel;
	print "$text{'index_inmod'}\n";
	print $modsel2;
	print "</td></form>\n";

	print "<form action=user_form.cgi><td align=right>\n";
	print "<input type=submit value='$text{'index_cuser'}'>\n";
	print "</td></form></tr>\n";

	if (@wgroups) {
		print "<tr><form action=edit_group.cgi><td>\n";
		print "<input type=submit value='$text{'index_egroup'}'>\n";
		print $groupsel;
		print "</td></form>\n";

		print "<form action=edit_acl.cgi><td>\n";
		print "<input type=submit value='$text{'index_egroupacl'}'>\n";
		print $groupsel;
		print "$text{'index_inmod'}\n";
		print $modsel2;
		print "</td></form>\n";
		}
	else {
		print "<tr> <td colspan=2></td>\n";
		}

	print "<form action=group_form.cgi><td align=right>\n";
	print "<input type=submit value='$text{'index_cgroup'}'>\n";
	print "</td></form></tr>\n";
	print "</table>\n";

	# Display modules lists and new module form
	print "<hr>\n";
	print "<h3>$text{'index_modules'}</h3>\n";
	print "<table cellpadding=0 cellspacing=0 width=100%><tr><td valign=top>\n";
	$formno += 2;
	print "<form action=edit_mod.cgi>\n";
	print "<input type=submit value=\"$text{'index_edit'}\">\n";
	print $modsel;
	print "<br>\n";

	print "<input type=submit name=tedit value=\"$text{'index_tedit'}\">\n";
	print $themesel;
	print "</form></td>\n";

	print "<td>$text{'index_installmsg'}<p>\n";
	print "<form action=install.cgi method=post ",
	      "enctype=multipart/form-data>\n";
	print "<input type=radio name=source value=0 checked> $text{'index_local'}\n";
	print "<input name=local size=50>\n";
	print &file_chooser_button("local", 0, $formno); print "<br>\n";
	print "<input type=radio name=source value=1> $text{'index_uploaded'}\n";
	print "<input type=file name=upload size=20><br>\n";
	print "<input type=radio name=source value=2> $text{'index_ftp'}\n";
	print "<input name=url size=50><br>\n";
	print "&nbsp;" x 5,"<input type=checkbox name=down value=1> ",
	      "$text{'index_down'}<p>\n";

	print "<input type=checkbox name=nodeps value=1> ",
	      "$text{'index_nodeps'}<p>\n";
	print "<input type=radio name=grant value=0 checked> ",
	      "$text{'index_grant2'}\n";
	print "<input name=grantto size=30 value='$base_remote_user'><br>\n";
	print "<input type=radio name=grant value=1> ",
	      "$text{'index_grant1'}<p>\n";

	print "<input type=submit value=\"$text{'index_installok'}\">\n";
	print "</form></td></tr></table>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});

