#!/usr/local/bin/perl
# view_raid.cgi
# Display information about a raid device

require './raid-lib.pl';
&foreign_require("mount", "mount-lib.pl");
&foreign_require("lvm", "lvm-lib.pl");
&foreign_require("fdisk", "fdisk-lib.pl");
&ReadParse();

&header($text{'view_title'}, "");
$conf = &get_raidtab();
$raid = $conf->[$in{'idx'}];
print "<hr>\n";

print "<form action=save_raid.cgi>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'view_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>$text{'view_device'}</b></td>\n";
print "<td><tt>$raid->{'value'}</tt></td> </tr>\n";

$lvl = &find_value('raid-level', $raid->{'members'});
print "<tr> <td><b>$text{'view_level'}</b></td>\n";
print "<td>",$lvl eq 'linear' ? $text{'linear'}
			      : $text{"raid$lvl"},"</td> </tr>\n";

@st = &device_status($raid->{'value'});
print "<tr> <td><b>$text{'view_status'}</b></td> <td>\n";
print $st[1] eq 'lvm' ? &text('view_lvm', "<tt>$st[0]</tt>") :
      $st[2] ? &text('view_mounted', "<tt>$st[0]</tt>") :
      @st ? &text('view_mount', "<tt>$st[0]</tt>") :
      $raid->{'active'} ? $text{'view_active'} :
			  $text{'view_inactive'};
print "</td> </tr>\n";

if ($raid->{'size'}) {
	print "<tr> <td><b>$text{'view_size'}</b></td>\n";
	print "<td>$raid->{'size'} blocks</td> </tr>\n";
	}
if ($raid->{'resync'}) {
	print "<tr> <td><b>$text{'view_resync'}</b></td>\n";
	print "<td>$raid->{'resync'} \%</td> </tr>\n";
	}

$super = &find_value('persistent-superblock', $raid->{'members'});
print "<tr> <td><b>$text{'view_super'}</b></td>\n";
print "<td>",$super ? $text{'yes'} : $text{'no'},"</td> </tr>\n";

if ($lvl eq '5') {
	$parity = &find_value('parity-algorithm', $raid->{'members'});
	print "<tr> <td><b>$text{'view_parity'}</b></td>\n";
	print "<td>",$parity ? $parity : $text{'default'},"</td> </tr>\n";
	}

$chunk = &find_value('chunk-size', $raid->{'members'});
print "<tr> <td><b>$text{'view_chunk'}</b></td>\n";
print "<td>$chunk kB</td> </tr>\n";

# Display partitions in RAID
print "<tr> <td valign=top><b>$text{'view_disks'}</b></td> <td>\n";
foreach $d (&find('device', $raid->{'members'})) {
	if (&find('raid-disk', $d->{'members'}) ||
            &find('parity-disk', $d->{'members'})) {
		local $name = &mount::device_name($d->{'value'});
		print $name,"\n";
		if (!&indevlist($d->{'value'}, $raid->{'devices'}) &&
		    $raid->{'active'}) {
			print "<font color=#ff0000>$text{'view_down'}</font>\n";
			}
		print "<br>\n";
		}
	}
print "</td> </tr>\n";

# Display spare partitions
foreach $d (&find('device', $raid->{'members'})) {
	if (&find('spare-disk', $d->{'members'})) {
		local $name = &mount::device_name($d->{'value'});
		$sp .= "$name<br>\n";
		}
	}
if ($sp) {
	print "<tr> <td valign=top><b>$text{'view_spares'}</b></td> <td>\n";
	print $sp,"</td> </tr>\n";
	}

print "</table></td></tr></table>\n";

if ($st[2]) {
	print "<br><b>$text{'view_cannot'}</b> <p>\n";
	}
else {
	if ($raid->{'active'}) {
		print "<input type=submit name=stop ",
		      "value='$text{'view_stop'}'>&nbsp;\n";
		}
	else {
		print "<input type=submit name=start ",
		      "value='$text{'view_start'}'>&nbsp;\n";
		}
	print "<input type=submit name=delete value='$text{'delete'}'>&nbsp;\n";
	if ($raid->{'active'}) {
		# Show buttons for creating filesystems
		&foreign_require("fdisk", "fdisk-lib.pl");
		print "<p><hr>\n";
		print "<table width=100%><tr>\n";
		print "<td nowrap><input type=submit name=mkfs ",
		      "value='$text{'view_mkfs2'}'>\n";
		print "<select name=fs>\n";
		foreach $f (&fdisk::supported_filesystems()) {
			printf "<option value=%s %s>%s (%s)\n",
				$f, $stat[1] eq $f ? "selected" : "",
				$fdisk::text{"fs_$f"}, $f;
			}
		print "</select></td>\n";
		print "<td>$text{'view_mkfsdesc'}</td>\n";
		print "</tr></table>\n";
		}
	}
print "</form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

# indevlist(device, &list)
sub indevlist
{
local $d;
foreach $d (@{$_[1]}) {
	return 1 if (&same_file($_[0], $d));
	}
return 0;
}

