#!/usr/local/bin/perl
# do_install.cgi
# Do the actual installation of a package from a file

require './software-lib.pl';
&ReadParse();
&error_setup(&text('do_err', $in{'package'}));

if ($show_install_progress) {
	$| = 1;
	$theme_no_table = 1;
	}
&header($text{'do_title'}, "");

foreach $p (&file_packages($in{'file'})) {
	# attempt to install
	print "<hr>\n";
	($package, $desc) = split(/\s+/, $p, 2);
	if ($show_install_progress) {
		print "<pre>\n";
		$error = &install_package($in{'file'}, &html_escape($package),
					  \%in, 1);
		print "</pre>\n";
		}
	else {
		$error = &install_package($in{'file'}, &html_escape($package));
		}
	if ($error) {
		print "<h3>",&text('do_efailed', $error),"</h3>\n";
		print $text{'do_efailedmsg1'},"<p>\n";
		if ($in{'need_unlink'}) {
			print &text('do_efailedmsg2',
				"delete_file.cgi?file=".
				&urlize($in{'file'})),"<p>\n";
			}
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}
	if ($in{'need_unlink'}) { unlink($in{'file'}); }

	# display information
	@pinfo = &show_package_info($package);
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'do_files'}</b></td> </tr>\n";
	print "<tr $cb> <td><table width=100%>\n";
	$n = &check_files($package);
	for($i=0; $i<$n; $i++) {
		if ($i%2 == 0) { print "<tr>\n"; }
		print "<td width=50%>",
			&html_escape($files{$i,'path'}),"</td>\n";
		if ($i%2 == 1) { print "</tr>\n"; }
		}
	print "</table></td></tr></table><p>\n";
	&list_packages($package);
	&webmin_log('install', 'package', $package,
		    { 'desc' => $packages{0,'desc'},
		      'class' => $packages{0,'class'} });
	}

print "<hr>\n";
&footer("", $text{'index_return'});

