#!/usr/local/bin/perl
# index.cgi
# Display sshd option categories

require './sshd-lib.pl';

# Check if config file exists
if (!-r $config{'sshd_config'}) {
	&header($text{'index_title'}, "", "intro", 1, 1);
	print "<hr>\n";
	print &text('index_econfig', "<tt>$config{'sshd_config'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if sshd exists
if (!&has_command($config{'sshd_path'})) {
	&header($text{'index_title'}, "", "intro", 1, 1);
	print "<hr>\n";
	print &text('index_esshd', "<tt>$config{'sshd_path'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}

# Check if sshd is the right version
$out = `$config{'sshd_path'} -h 2>&1`;
if ($out =~ /(sshd\s+version\s+([0-9\.]+))/i ||
    $out =~ /(ssh\s+secure\s+shell\s+([0-9\.]+))/i) {
	# Classic commercial SSH
#	if ($2 >= 3) {
#		&header($text{'index_title'}, "", "intro", 1, 1);
#		print "<hr>\n";
#		print &text('index_eversion2',
#			    "<tt>$config{'sshd_path'}</tt>", "$2"),"<p>\n";
#		print "<hr>\n";
#		&footer("/", $text{"index"});
#		exit;
#		}
	$version{'type'} = 'ssh';
	$version{'number'} = $2;
	$version{'full'} = $1;
	}
elsif ($out =~ /(OpenSSH.([0-9\.]+))/i) {
	# OpenSSH .. assume all versions are supported
	$version{'type'} = 'openssh';
	$version{'number'} = $2;
	$version{'full'} = $1;
	}
elsif ($out =~ /(Sun_SSH_([0-9\.]+))/i) {
	# Solaris 9 SSH is actually OpenSSH 2.x
	$version{'type'} = 'openssh';
	$version{'number'} = 2.0;
	$version{'full'} = $1;
	}
else {
	# Unknown version
	&header($text{'index_title'}, "", "intro", 1, 1);
	print "<hr>\n";
	print &text('index_eversion', "<tt>$config{'sshd_path'}</tt>",
		    "$gconfig{'webprefix'}/config.cgi?$module_name",
		    "<tt>$config{'sshd_path'} -h</tt>",
		    "<pre>$out</pre>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{"index"});
	exit;
	}
&write_file("$module_config_directory/version", \%version);

&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("ssh", "man", "doc", "google"), undef, undef,
	&text('index_version', $version{'full'}));
print "<hr>\n";

# Display icons for options
foreach $i ('users', 'net', 'access', 'misc') {
	push(@links, "edit_$i.cgi");
	push(@titles, $text{$i.'_title'});
	push(@icons, "images/$i.gif");
	}
if (-r $config{'client_config'}) {
	push(@links, "list_hosts.cgi");
	push(@titles, $text{'hosts_title'});
	push(@icons, "images/hosts.gif");
	}
push(@links, "edit_sync.cgi");
push(@titles, $text{'sync_title'});
push(@icons, "images/sync.gif");
&icons_table(\@links, \@titles, \@icons, scalar(@links));

# Check if sshd is running
$conf = &get_sshd_config();
$pidfile = &find_value("PidFile", $conf);
$pidfile = $config{'pid_file'} if (!$pidfile);
if (open(PID, $pidfile) && ($pid = int(<PID>)) && kill(0, $pid)) {
	# Running .. offer to apply changes
	print "<hr>\n";
	print "<form action=apply.cgi>\n";
	print "<input name=pid type=hidden value='$pid'>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'}</td>\n";
	print "</tr></table></form>\n";
	}
else {
	# Not running .. offer to start
	print "<hr>\n";
	print "<form action=start.cgi>\n";
	print "<table width=100%><tr>\n";
	print "<td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'}</td>\n";
	print "</tr></table></form>\n";
	}
close(PID);

print "<hr>\n";
&footer("/", $text{"index"});

