#!/usr/local/bin/perl
# index.cgi
# Display the telnet applet

require '../web-lib.pl';
use Socket;
&init_config();
$theme_no_table = 1 if ($config{'sizemode'} == 1);
&header($text{'index_title'}, "", undef, 1, 1);
print "<hr>\n";

if ($ENV{'HTTPS'} eq 'ON' && !$config{'mode'}) {
	print "<center><font color=#ff0000>$text{'index_warn'}",
	      "</font></center><br>\n";
	}

if ($config{'no_test'}) {
	# Just assume that the telnet server is running
	$rv = 1;
	}
else {
	# Check if the telnet server is running
	$addr = $config{'host'} ? $config{'host'} :
		$ENV{'SERVER_NAME'} ? $ENV{'SERVER_NAME'} :
				      &to_ipaddress(&get_system_hostname());
	$port = $config{'port'} ? $config{'port'} :
		$config{'mode'} ? 22 : 23;
	if (inet_aton($addr)) {
		socket(STEST, PF_INET, SOCK_STREAM, getprotobyname("tcp"));
		$SIG{ALRM} = "connect_timeout";
		alarm(10);
		$rv = connect(STEST, sockaddr_in($port, inet_aton($addr)));
		close(STEST);
		}
	}
if (!$rv) {
	if (inet_aton($addr)) {
		print "<p>",&text(
			$config{'mode'} ? 'index_esocket2' : 'index_esocket',
			$addr, $port),"<p>\n";
		}
	else {
		print "<p>",&text('index_elookup', $addr),"<p>\n";
		}
	}
else {
	print "<center>\n";
	if ($config{'detach'}) {
		$w = 100; $h = 50;
		}
	elsif ($config{'sizemode'} == 2 &&
	    $config{'size'} =~ /^(\d+)\s*x\s*(\d+)$/) {
		$w = $1; $h = $2;
		}
	elsif ($config{'sizemode'} == 1) {
		$w = "100%"; $h = "80%";
		}
	else {
		$w = 590; $h = 360;
		}
	print "<applet archive=\"jta20.jar\" code=de.mud.jta.Applet ",
	      "width=$w height=$h>\n";
	printf "<param name=config value=%s>\n",
		$config{'mode'} ? "ssh.conf" : "telnet.conf";
	if ($config{'port'}) {
		print "<param name=Socket.port value=$config{'port'}>\n";
		}
	if ($config{'host'}) {
		print "<param name=Socket.host value=$config{'host'}>\n";
		}
	if ($config{'script'}) {
		print "<param name=Script.script value='$config{'script'}'>\n";
		}
	if ($config{'sizemode'}) {
		print "<param name=Terminal.resize value='screen'>\n";
		}
	if ($config{'fontsize'}) {
		print "<param name=Terminal.fontSize value='$config{'fontsize'}'>\n";
		}
	if ($config{'detach'}) {
		print "<param name=Applet.detach value='true'>\n";
		}
	print "$text{'index_nojava'} <p>\n";
	print "</applet><br>\n";

	print &text('index_credits',
		    "http://www.mud.de/se/jta/"),"<br>\n";
	if ($config{'mode'}) {
		print &text('index_sshcredits',
			    "http://www.systemics.com/docs/cryptix/"),"<br>\n";
		}
	print "</center>\n";
	}
print "<hr>\n";
&footer("/", $text{'index'});

sub connect_timeout
{
}

