#!/usr/local/bin/perl
# index.cgi
# Display usermin configuration categories

require './usermin-lib.pl';

if (!-r "$config{'usermin_dir'}/miniserv.conf") {
	&header($text{'index_title'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>",&text('index_econfig', "<tt>$config{'usermin_dir'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

$ver = &get_usermin_version();
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("usermin", "google"), undef, undef,
	&text('index_version', $ver));
print "<hr>\n";

@links = ( "edit_access.cgi", "edit_bind.cgi", "edit_ui.cgi", "edit_mods.cgi",
	   "edit_os.cgi", "edit_lang.cgi", "edit_upgrade.cgi",
	   "edit_session.cgi", "edit_assignment.cgi", "edit_categories.cgi",
	   "edit_themes.cgi", "edit_ssl.cgi", "list_configs.cgi",
	   "edit_acl.cgi", $ver < 0.942 ? ( ) : ( "list_restrict.cgi" ),
	   $ver < 0.76 ? ( ) : ( "edit_users.cgi", "edit_defacl.cgi" ) );
@titles = map { /_(\S+).cgi/; $text{"${1}_title"} } @links;
@icons = map { /_(\S+).cgi/; "images/$1.gif" } @links;
for($i=0; $i<@links; $i++) {
	$links[$i] =~ /_(\S+).cgi/;
	if (!$access{$1}) {
		splice(@links, $i, 1);
		splice(@titles, $i, 1);
		splice(@icons, $i, 1);
		}
	}
&icons_table(\@links, \@titles, \@icons);

if ($access{'stop'}) {
	print "<hr>\n";
	print "<table width=100%><tr>\n";
	&get_usermin_miniserv_config(\%miniserv);
	if (open(PID, $miniserv{'pidfile'}) && ($pid = int(<PID>)) &&
	    kill(0, $pid)) {
		close(PID);
		print "<form action=stop.cgi>\n";
		print "<td><input type=submit ",
		      "value='$text{'index_stop'}'></td>\n";
		print "<td>$text{'index_stopmsg'}</td></form>\n";
		}
	else {
		print "<form action=start.cgi>\n";
		print "<td><input type=submit ",
		      "value='$text{'index_start'}'></td>\n";
		print "<td>$text{'index_startmsg'}</td></form>\n";
		}
	print "</tr></table>\n";
	}

if (&foreign_check("init") && (%iconfig = &foreign_config("init")) &&
    $iconfig{'init_dir'} && $access{'bootup'}) {
	print "<hr>\n" if (!$access{'stop'});
	print "<table width=100%><tr>\n";
	&foreign_require("init", "init-lib.pl");
	$starting = &init::action_status("usermin");
	print "<form action=bootup.cgi>\n";
	print "<input type=hidden name=starting value='$starting'>\n";
	print "<td nowrap><input type=submit value='$text{'index_boot'}'>\n";
	printf "<input type=radio name=boot value=1 %s> %s\n",
		$starting == 2 ? "checked" : "", $text{'yes'};
	printf "<input type=radio name=boot value=0 %s> %s</td>\n",
		$starting == 2 ? "" : "checked", $text{'no'};
	print "<td>$text{'index_bootmsg'}</td>\n";
	print "</form></tr></table>\n";
	}

print "<hr>\n";
&footer("/", $text{'index'});
