#!/usr/local/bin/perl
# index.cgi
# Display all xinetd services

require './xinetd-lib.pl';
&header($text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("xinetd", "man", "doc", "google"));
print "<hr>\n";

# Check for config file
if (!-r $config{'xinetd_conf'}) {
	print "<p>",&text('index_econf', "<tt>$config{'xinetd_conf'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p><hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

@conf = &get_xinetd_config();
($defs) = grep { $_->{'name'} eq 'defaults' } @conf;
foreach $m (@{$defs->{'members'}}) {
	$ddisable{$m->{'value'}}++ if ($m->{'name'} eq 'disabled');
	}

print "<a href='edit_serv.cgi?new=1'>$text{'index_add_inet'}</a><br>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'index_name'}</b></td> ",
      "<td><b>$text{'index_type'}</b></td> ",
      "<td><b>$text{'index_port'}</b></td> ",
      "<td><b>$text{'index_proto'}</b></td> ",
      "<td><b>$text{'index_user'}</b></td> ",
      "<td><b>$text{'index_server'}</b></td> ",
      "<td><b>$text{'index_enabled'}</b></td> </tr>\n";
foreach $x (@conf) {
	next if ($x->{'name'} ne 'service');
	local $q = $x->{'quick'};
	local @s;
	if ($q->{'type'}->[0] eq 'UNLISTED') {
		@s = ( $x->{'name'}, undef, $q->{'port'}->[0],
		       $q->{'protocol'}->[0] );
		}
	elsif ($q->{'protocol'}) {
		@s = getservbyname($x->{'value'}, $q->{'protocol'}->[0]);
		if (!@s) {
			@s = ( $x->{'name'}, undef, $q->{'port'}->[0],
			       $q->{'protocol'}->[0] );
			}
		}
	else {
		foreach $p (&list_protocols()) {
			@s = getservbyname($x->{'value'}, $p);
			last if (@s);
			}
		}
	print "<tr $cb>\n";
	print "<td><a href='edit_serv.cgi?idx=$x->{'index'}'>",
	      &html_escape($x->{'value'}),"</a></td>\n";
	print "<td>",&indexof('RPC', @{$q->{'type'}}) < 0 ?
		     $text{'index_inet'} : $text{'index_rpc'},"</td>\n";
	print "<td>",&html_escape($s[2]),"</td>\n";
	print "<td>",&html_escape(uc($s[3])),"</td>\n";
	print "<td>",$q->{'user'} ? &html_escape($q->{'user'}->[0])
				  : "<br>","</td>\n";
	print "<td>",&indexof('INTERNAL', @{$q->{'type'}}) >= 0 ?
		     $text{'index_internal'} : $q->{'redirect'} ?
		     &text('index_redirect', "<tt>".&html_escape($q->{'redirect'}->[0])."</tt>") :
		     &html_escape($q->{'server'}->[0]),"</td>\n";
	$id = $q->{'id'}->[0] || $x->{'value'};
	print "<td>",$q->{'disable'}->[0] eq 'yes' || $ddisable{$id} ?
	      "<font color=#ff0000>$text{'no'}</font>" : $text{'yes'},"</td>\n";
	print "</tr>\n";
	}
print "</table>\n";
print "<a href='edit_serv.cgi?new=1'>$text{'index_add_inet'}</a><p>\n";

print "<hr>\n";
print "<table>\n";
print "<form action=edit_defaults.cgi>\n";
print "<tr> <td><input type=submit value=\"$text{'index_defaults'}\"></td>\n";
print "<td>$text{'index_defaultsmsg'} \n";
print "</td> </tr>\n";
print "</form>\n";

if ($config{'pid_file'}) {
	if (open(PID, $config{'pid_file'})) {
		chop($pid = <PID>);
		close(PID);
		}
	}
else {
	($pid) = &find_byname("xinetd");
	}
if ($pid && kill(0, $pid)) {
	print "<form action=restart.cgi>\n";
	print "<input type=hidden name=pid value=$pid>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_apply'}\"></td>\n";
	print "<td>$text{'index_applymsg'} \n";
	print "</td></tr>\n";
	print "</form>\n";
	}
else {
	print "<form action=start.cgi>\n";
	print "<tr> <td><input type=submit value=\"$text{'index_start'}\"></td>\n";
	print "<td>$text{'index_startmsg'} \n";
	print "</td> </tr>\n";
	print "</form>\n";
	}
print "</table>\n";

print "<hr>\n";
&footer("/", $text{'index'});

