# mod_php4.pl
# PHP4 Directives
# By Sebastian Delmont <sdelmont@loquesea.com>

sub mod_php4_directives
{
$rv = [ [ 'php_value', 1, 16, 'virtual directory htaccess', undef, 10 ],
	[ 'php_flag', 1, 16, 'virtual directory htaccess', undef, 2 ] ];
return &make_directives($rv, $_[0], "mod_php4");
}

sub mod_php4_handlers
{
return ("php4-script");
}

sub edit_php_value
{
local($rv, $name, $value, $len);
$rv = "";

$len = @{$_[0]} + 1;
for($i=0; $i<$len; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(.+)$/) {
		$name = $1; $value = $2;
		}
	else { $name = $value = ""; }
	$rv .= "<input name=mod_php_value_name_$i size=20 value='$name'>&nbsp;";
	$rv .= "<input name=mod_php_value_value_$i size=30 value='$value'><BR>\n";
	}
return (2, "$text{'mod_php_value'}", $rv);
}

sub save_php_value
{
local($i, $name, $value, @rv);
for($i=0; defined($in{"mod_php_value_name_$i"}); $i++) {
	$name = $in{"mod_php_value_name_$i"}; $value = $in{"mod_php_value_value_$i"};
	if ($name !~ /\S/ && $value !~ /\S/) { next; }
	$name =~ /^(\S+)$/ || &error(&text('mod_php_ename', $name));
	$value =~ /^(.+)$/ || &error(&text('mod_php_evalue', $name, $value));
	push(@rv, "$name $value");
	}
return ( \@rv );
}

sub edit_php_flag
{
local($rv, $name, $value, $len);
$rv = "";

$len = @{$_[0]} + 1;
for($i=0; $i<$len; $i++) {
	if ($_[0]->[$i]->{'value'} =~ /^(\S+)\s+(on|off)$/) {
		$name = $1; $value = $2;
		}
	else { $name = $value = ""; }
	$rv .= "<input name=mod_php_flag_name_$i size=20 value='$name'>&nbsp;";
	$rv .= "<input name=mod_php_flag_value_$i type=radio value=on" . ($value eq "on" ? " checked" : "" ) . ">on&nbsp;";
	$rv .= "<input name=mod_php_flag_value_$i type=radio value=off" . ($value eq "off" ? " checked" : "" ) . ">off&nbsp;<BR>";
	}
return (2, "$text{'mod_php_flag'}", $rv);
}

sub save_php_flag
{
local($i, $name, $value, @rv);
for($i=0; defined($in{"mod_php_flag_name_$i"}); $i++) {
	$name = $in{"mod_php_flag_name_$i"}; $value = $in{"mod_php_flag_value_$i"};
	if ($name !~ /\S/ ) { next; }
	$name =~ /^(\S+)$/ || &error(&text('mod_php_ename', $name));
	$value =~ /^(on|off)$/i || &error(&text('mod_php_evalue', $name, $value));
	push(@rv, "$name $value");
	}
return ( \@rv );
}

1;
