#!/usr/local/bin/perl
# find_zones.cgi
# Display zones matching some search

require './bind8-lib.pl';
&ReadParse();
%access = &get_module_acl();

$conf = &get_config();
@views = &find("view", $conf);
foreach $v (@views) {
	@vz = &find("zone", $v->{'members'});
	map { $view{$_} = $v } @vz;
	push(@zones, @vz);
	}
push(@zones, &find("zone", $conf));
foreach $z (@zones) {
	$v = $z->{'value'};
	next if ($v eq "." || !&can_edit_zone(\%access, $z) ||
		 $v !~ /$in{'search'}/);
	$t = &find("type", $z->{'members'})->{'value'};
	if ($view{$z}) {
		push(@zlinks, "edit_$t.cgi?index=$z->{'index'}".
			      "&view=$view{$z}->{'index'}");
		push(@ztitles, &ip6int_to_net(&arpa_to_ip($v))." ".
		       &text('index_view', "<tt>$view{$z}->{'value'}</tt>"));
		}
	else {
		push(@zlinks, "edit_$t.cgi?index=$z->{'index'}");
		push(@ztitles, &ip6int_to_net(&arpa_to_ip($v)));
		}
	push(@zicons, "images/$t.gif");
	push(@ztypes, $text{"index_$t"});
	$len++;
	}
if (@zlinks == 1) {
	&redirect($zlinks[0]);
	exit;
	}

&header($text{'find_title'}, "");
print "<hr>\n";
print "<p>",&text('find_match', "<tt>$in{'search'}</tt>"),"<p>\n";

if ($len) {
	# sort list of zones
	@zorder = sort { $ztitles[$a] cmp $ztitles[$b] } (0 .. $len-1);
	@zlinks = map { $zlinks[$_] } @zorder;
	@ztitles = map { $ztitles[$_] } @zorder;
	@zicons = map { $zicons[$_] } @zorder;
	@ztypes = map { $ztypes[$_] } @zorder;

	if ($config{'show_list'}) {
		# display as list
		$mid = int((@zlinks+1)/2);
		print "<table width=100%><tr><td width=50% valign=top>\n";
		&zones_table([ @zlinks[0 .. $mid-1] ],
			     [ @ztitles[0 .. $mid-1] ],
			     [ @ztypes[0 .. $mid-1] ]);
		print "</td><td width=50% valign=top>\n";
		if ($mid < @zlinks) {
			&zones_table([ @zlinks[$mid .. $#zlinks] ],
				     [ @ztitles[$mid .. $#ztitles] ],
				     [ @ztypes[$mid .. $#ztypes] ]);
			}
		print "</td></tr></table>\n";
		}
	else {
		# display as icons
		&icons_table(\@zlinks, \@ztitles, \@zicons);
		}
	}
else {
	print "<b>$text{'find_none'}</b><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});


