#!/usr/local/bin/perl
# restart_zone.cgi
# Apply changes to one zone only using the ndc command

require './bind8-lib.pl';
&ReadParse();
%access = &get_module_acl();
$access{'ro'} && &error($text{'restart_ecannot'});
$access{'apply'} || &error($text{'restart_ecannot'});
$conf = &get_config();
if ($in{'view'} ne '') {
	$conf = $conf->[$in{'view'}]->{'members'};
	}
$dom = $conf->[$in{'index'}]->{'value'};
$out = &backquote_logged("$config{'ndc_cmd'} reload '$dom' 2>&1 </dev/null");
if ($? || $out =~ /failed|not found|error/i) {
	&error(&text('restart_endc', "<tt>$out</tt>"));
	}
&webmin_log("apply", $dom);
&redirect("edit_master.cgi?index=$in{'index'}&view=$in{'view'}");

