#!/usr/local/bin/perl
# fsdump-lib.pl
# Common functions for doing filesystem backups with dump

do '../web-lib.pl';
&init_config();
do "$gconfig{'os_type'}-lib.pl";
&foreign_require("mount", "mount-lib.pl");

$cron_cmd = "$module_config_directory/backup.pl";

# list_dumps()
# Returns a list of all scheduled dumps
sub list_dumps
{
local (@rv, $f);
opendir(DIR, $module_config_directory);
foreach $f (sort { $a cmp $b } readdir(DIR)) {
	next if ($f !~ /^(\S+)\.dump$/);
	push(@rv, &get_dump($1));
	}
closedir(DIR);
return @rv;
}

# get_dump(id)
sub get_dump
{
local %dump;
&read_file("$module_config_directory/$_[0].dump", \%dump);
$dump{'id'} = $_[0];
return \%dump;
}

# save_dump(&dump)
sub save_dump
{
$_[0]->{'id'} = $$.time() if (!$_[0]->{'id'});
&lock_file("$module_config_directory/$_[0]->{'id'}.dump");
&write_file("$module_config_directory/$_[0]->{'id'}.dump", $_[0]);
&unlock_file("$module_config_directory/$_[0]->{'id'}.dump");
}

# delete_dump(&dump)
sub delete_dump
{
&lock_file("$module_config_directory/$_[0]->{'id'}.dump");
unlink("$module_config_directory/$_[0]->{'id'}.dump");
&unlock_file("$module_config_directory/$_[0]->{'id'}.dump");
}

# directory_filesystem(dir)
# Returns the filesystem type of some directory 
sub directory_filesystem
{
local $type;
foreach $m (sort { length($a->[0]) <=> length($b->[0]) }
	         &foreign_call("mount", "list_mounted")) {
	local $l = length($m->[0]);
	if ($m->[0] eq $_[0] || $m->[0] eq "/" ||
	    (length($_[0]) >= $l && substr($_[0], 0, $l+1) eq $m->[0]."/")) {
		$type = $m->[2];
		}
	}
return $type;
}

sub dump_when
{
if ($_[0]->{'mins'} eq '*' && $_[0]->{'hours'} eq '*' && $_[0]->{'days'} eq '*' && $_[0]->{'months'} eq '*' && $_[0]->{'weekdays'} eq '*') {
	return $text{'when_min'};
	}
elsif ($_[0]->{'mins'} =~ /^\d+$/ && $_[0]->{'hours'} eq '*' && $_[0]->{'days'} eq '*' && $_[0]->{'months'} eq '*' && $_[0]->{'weekdays'} eq '*') {
	return &text('when_hour', $_[0]->{'mins'});
	}
elsif ($_[0]->{'mins'} =~ /^\d+$/ && $_[0]->{'hours'} =~ /^\d+$/ && $_[0]->{'days'} eq '*' && $_[0]->{'months'} eq '*' && $_[0]->{'weekdays'} eq '*') {
	return &text('when_day', sprintf("%2.2d", $_[0]->{'mins'}), $_[0]->{'hours'});
	}
elsif ($_[0]->{'mins'} =~ /^\d+$/ && $_[0]->{'hours'} =~ /^\d+$/ && $_[0]->{'days'} =~ /^\d+$/ && $_[0]->{'months'} eq '*' && $_[0]->{'weekdays'} eq '*') {
	return &text('when_month', sprintf("%2.2d", $_[0]->{'mins'}), $_[0]->{'hours'}, $_[0]->{'days'});
	}
elsif ($_[0]->{'mins'} =~ /^\d+$/ && $_[0]->{'hours'} =~ /^\d+$/ && $_[0]->{'days'} eq '*' && $_[0]->{'months'} eq '*' && $_[0]->{'weekdays'} =~ /^\d+$/) {
	return &text('when_weekday', sprintf("%2.2d", $_[0]->{'mins'}), $_[0]->{'hours'}, $text{"day_".$_[0]->{'weekdays'}});
	}
else {
	return &text('when_cron', join(" ", $_[0]->{'mins'}, $_[0]->{'hours'}, $_[0]->{'days'}, $_[0]->{'months'}, $_[0]->{'weekdays'}));
	}
}

# date_subs(string)
sub date_subs
{
if ($config{'date_subs'}) {
	eval "use POSIX";
	local @tm = localtime(time());
	return strftime($_[0], @tm);
	}
else {
	return $_[0];
	}
}

# execute_before(&dump, handle, escape)
sub execute_before
{
if ($_[0]->{'before'}) {
	local $h = $_[1];
	open(BEFORE, "($_[0]->{'before'}) 2>&1 </dev/null |");
	while(<BEFORE>) {
		print $h $_[2] ? &html_escape($_) : $_;
		}
	close(BEFORE);
	}
}

# execute_after(&dump, handle, escape)
sub execute_after
{
if ($_[0]->{'after'}) {
	local $h = $_[1];
	open(AFTER, "($_[0]->{'after'}) 2>&1 </dev/null |");
	while(<AFTER>) {
		print $h $_[2] ? &html_escape($_) : $_;
		}
	close(AFTER);
	}
}

1;

