#!/usr/local/bin/perl
# index.cgi
# Display a list of scheduled dumps

require './fsdump-lib.pl';
&header($text{'index_title'}, "", "intro", 1, 1);
print "<hr>\n";

@fslist = &supported_filesystems();
if (!@fslist) {
	print "<p>",&text('index_ecommands', "<tt>dump</tt>"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}

@dumps = &list_dumps();
if (@dumps) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'dump_dir'}</b></td>\n";
	print "<td><b>$text{'dump_fs'}</b></td>\n";
	print "<td><b>$text{'dump_level'}</b></td>\n";
	print "<td><b>$text{'dump_dest'}</b></td>\n";
	print "<td><b>$text{'dump_sched'}</b></td>\n";
	print "<td><b>$text{'dump_when'}</b></td> </tr>\n";
	foreach $d (@dumps) {
		print "<tr $cb>\n";
		print "<td><a href='edit_dump.cgi?id=$d->{'id'}'><tt>",
		      &html_escape($d->{'dir'}),"</tt></a></td>\n";
		print "<td>",uc($d->{'fs'}),"</td>\n";
		print "<td>",&html_escape($d->{'level'}),"</td>\n";
		print "<td><tt>",&dump_dest($d),"</tt></td>\n";
		print "<td>",$d->{'enabled'} ? $text{'yes'} : $text{'no'},"</td>\n";
		print "<td>",&dump_when($d),"</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'index_none'}</b><p>\n";
	}
print "<form action=edit_dump.cgi>\n";
print "<input type=submit value='$text{'index_add'}'>\n";
print "<input name=dir size=20> ",&file_chooser_button("dir"),"\n";
print "</form>\n";

# Display restore button
print "<hr>\n";
print "<form action=restore_form.cgi>\n";
print "<table width=100%><tr>\n";
print "<td nowrap><input type=submit value='$text{'index_restore'}'>";
print "<select name=fs>\n";
foreach $f (&supported_filesystems()) {
	printf "<option value=%s>%s\n", $f, uc($f);
	}
print "</select></td>\n";
print "<td>$text{'index_restoremsg'}</td>\n";
print "</tr></table></form>\n";

print "<hr>\n";
&footer("/", $text{'index'});

