#!/usr/local/bin/perl
# index.cgi
# Display all existing databases

require './mysql-lib.pl';

# Check for MySQL programs
if (!-x $config{'mysqladmin'}) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_eadmin', "<tt>$config{'mysqladmin'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
if (!-x $config{'mysql'}) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_esql', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$out = `$config{'mysql'} -V 2>&1`;
if ($out =~ /lib\S+\.so/) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_elibrary', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
elsif ($out !~ /distrib\s+((3|4)\.[0-9\.]*)/i) {
	&header($text{'index_title'}, "", "intro", 1, 1, 0,
		&help_search_link("mysql", "man", "doc", "google"));
	print "<hr>\n";
	print "<p>",&text('index_ever', "<tt>$config{'mysql'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index'});
	exit;
	}
$mysql_version = $1;
open(VERSION, ">$module_config_directory/version");
print VERSION $mysql_version,"\n";
close(VERSION);
&header($text{'index_title'}, "", "intro", 1, 1, 0,
	&help_search_link("mysql", "man", "doc", "google"),
	undef, undef, &text('index_version', $mysql_version));
print "<hr>\n";

$r = &is_mysql_running();
if ($r == 0) {
	# Not running .. need to start it
	print "<p> <b>$text{'index_notrun'}</b> <p>\n";

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=start.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_start'}\"></td>\n";
		print "<td>",&text('index_startmsg',
		      "<tt>$config{'start_cmd'}</tt>"),"</td> </tr></table>\n";
		print "</form>\n";
		}
	}
elsif ($r == -1 && $access{'user'}) {
	# Running, but the user's password is wrong
	print "<p> <b>",&text('index_nouser', "<tt>$access{'user'}</tt>"),
	      "</b><p>\n";
	}
elsif ($r == -1) {
	# Running, but webmin doesn't know the root password!
	print "<p> <b>$text{'index_nopass'}</b> <p>\n";
	print "<form action=login.cgi method=post>\n";
	print "<center><table border>\n";
	print "<tr $tb> <td><b>$text{'index_ltitle'}</b></td> </tr>\n";
	print "<tr $cb> <td><table cellpadding=2>\n";
	print "<tr> <td><b>$text{'index_login'}</b></td>\n";
	printf "<td><input name=login size=20 value='%s'></td> </tr>\n",
		$config{'login'};
	print "<tr> <td><b>$text{'index_pass'}</b></td>\n";
	print "<td><input name=pass size=20 type=password></td>\n";
	print "</tr> </table></td></tr></table>\n";
	print "<input type=submit value='$text{'save'}'>\n";
	print "<input type=reset value='$text{'index_clear'}'>\n";
	print "</center></form>\n";
	}
else {
	# Running .. list databases
	print "<h3>$text{'index_dbs'}</h3>\n";
	@titles = grep { &can_edit_db($_) } &list_databases();
	@icons = map { "images/db.gif" } @titles;
	@links = map { "edit_dbase.cgi?db=$_" } @titles;
	print "<a href=newdb_form.cgi>$text{'index_add'}</a> <br>\n"
		if ($access{'create'});
	if ($config{'style'}) {
		@tables = map { @t = &list_tables($_); scalar(@t) } @titles;
		@titles = map { &html_escape($_) } @titles;
		&split_table([ $text{'index_db'}, $text{'index_tables'} ],
			     \@links, \@titles, \@tables) if (@titles);
		}
	else {
		@titles = map { &html_escape($_) } @titles;
		&icons_table(\@links, \@titles, \@icons);
		}
	print "<a href=newdb_form.cgi>$text{'index_add'}</a> <p>\n"
		if ($access{'create'});

	if ($access{'perms'}) {
		print "<hr>\n";
		print "<h3>$text{'index_global'}</h3>\n";
		@links = ( 'list_users.cgi', 'list_dbs.cgi', 'list_hosts.cgi',
			   'list_tprivs.cgi', 'list_cprivs.cgi' );
		@titles = ( $text{'users_title'}, $text{'dbs_title'},
			    $text{'hosts_title'}, $text{'tprivs_title'},
			    $text{'cprivs_title'} );
		@images = ( 'images/users.gif', 'images/dbs.gif',
			    'images/hosts.gif', 'images/tprivs.gif',
			    'images/cprivs.gif' );
		if ($access{'perms'} == 2) {
			shift(@links); shift(@titles); shift(@images);
			}
		&icons_table(\@links, \@titles, \@images, 5);
		}

	if ($access{'stop'}) {
		print "<hr>\n";
		print "<form action=stop.cgi>\n";
		print "<table width=100%><tr><td>\n";
		print "<input type=submit ",
		      "value=\"$text{'index_stop'}\"></td>\n";
		print "<td>$text{'index_stopmsg'}</td> </tr></table>\n";
		print "</form>\n";
		}
	}

print "<hr>\n";
&footer("/", "index");

