# passwd-lib.pl
# Common functions for the password module

do '../web-lib.pl';
&init_config();
%access = &get_module_acl();

# can_edit_passwd(&user)
sub can_edit_passwd
{
if ($access{'mode'} == 0) {
	return 1;
	}
elsif ($access{'mode'} == 3) {
	return $_[0]->[0] eq $remote_user;
	}
elsif ($access{'mode'} == 4) {
	return (!$access{'low'} || $_[0]->[2] >= $access{'low'}) &&
	       (!$access{'high'} || $_[0]->[2] <= $access{'high'});
	}
elsif ($access{'mode'} == 5) {
	local $g = getgrgid($_[0]->[3]);
	return &indexof($g, split(/\s+/, $access{'users'})) >= 0;
	}
elsif ($access{'mode'} == 6) {
	return $_[0]->[0] =~ /$access{'users'}/;
	}
else {
	local $idx = &indexof($_[0]->[0], split(/\s+/, $access{'users'}));
	return $access{'mode'} == 1 && $idx >= 0 ||
	       $access{'mode'} == 2 && $idx < 0;
	}
}

1;

