#!/usr/local/bin/perl
# list_boxes.cgi
# List the mailboxes of all local users

require './sendmail-lib.pl';
require './boxes-lib.pl';

if ($access{'mmode'} == 0) {
	&error($text{'boxes_ecannot'});
	}
elsif ($access{'mmode'} == 2) {
	if ($access{'musers'} =~ /^\S+$/) {
		&redirect("list_mail.cgi?user=$access{'musers'}");
		exit;
		}
	foreach $u (split(/\s+/, $access{'musers'})) {
		$ucan{$u}++;
		}
	}
elsif ($access{'mmode'} == 3) {
	foreach $u (split(/\s+/, $access{'musers'})) {
		$ucant{$u}++;
		}
	}
elsif ($access{'mmode'} == 4) {
	&redirect("list_mail.cgi?user=$remote_user");
	exit;
	}

&header($text{'boxes_title'}, "");
print "<hr>\n";

setpwent();
while(@u = getpwent()) {
	next if (!$ucan{$u[0]} && $access{'mmode'} == 2);
	next if ($ucant{$u[0]} && $access{'mmode'} == 3);
	next if ($u[0] ne $remote_user && $access{'mmode'} == 4);
	next if ($u[3] ne $access{'musers'} && $access{'mmode'} == 5);
	next if ($access{'mmode'} == 6 && $u[0] !~ /^$access{'musers'}$/);
	local $umf = &user_mail_file(@u);
	next if ($donefile{$umf}++);
	local @st = stat($umf);
	push(@users, [ $u[0], $st[7] ]);
	$done_sent++ if ($u[0] eq $access{'sent'});
	}
endpwent() if ($gconfig{'os_type'} ne 'hpux');
@users = sort { $b->[1] <=> $a->[1] } @users;
if ($access{'sent'} && !$done_sent) {
	local @st = stat(&user_mail_file($access{'sent'}));
	push(@users, [ $access{'sent'}, $st[7] ]);
	}

if ($config{'max_records'} && @users > $config{'max_records'}) {
	# Use input for jumping to one user
	print $text{'boxes_toomany'},"<br>\n";
	print "<form action=list_mail.cgi>\n";
	print "<input type=submit value='$text{'boxes_go'}'>\n";
	print &unix_user_input("user"),"</form>\n";
	}
else {
	# Show table of users
	print "<table width=100%><tr><td valign=top width=50%>\n";
	$mid = int((@users+1) / 2);
	&users_table(@users[0 .. $mid-1]);
	print "</td><td valign=top width=50%>\n";
	&users_table(@users[$mid .. $#users]);
	print "</td></tr></table><p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

sub users_table
{
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'boxes_user'}</b></td> ",
      "<td><b>$text{'boxes_size'}</b></td> </tr>\n";
foreach $u (@_) {
	print "<tr $cb> <td><a href=\"list_mail.cgi?user=$u->[0]\">",
	      $u->[0] eq $access{'sent'} ? $text{'boxes_sent'} : $u->[0],
	      "</a></td>\n";
	print "<td>",defined($u->[1]) ? $u->[1]
				      : $text{'boxes_none'},"</td> </tr>\n";
	}
print "</table>\n";
}

