#!/usr/local/bin/perl
# list_mailq.cgi
# Display the current mail queue

require './sendmail-lib.pl';
$access{'mailq'} || &error($text{'mailq_ecannot'});
print "Refresh: $config{'mailq_refresh'}\r\n"
	if ($config{'mailq_refresh'});
&header($text{'mailq_title'}, "");
print "<hr><p>\n";

$conf = &get_sendmailcf();
foreach $mqueue (&mailq_dir($conf)) {
	opendir(QDIR, $mqueue);
	push(@qfiles, map { "$mqueue/$_" } grep { /^qf/ } readdir(QDIR));
	closedir(QDIR);
	}

map { @st = stat($_); $stamp{$_} = $st[9] } @qfiles;
@qfiles = sort { $stamp{$a} <=> $stamp{$b} } @qfiles;

if (@qfiles) {
	print "<form action=del_mailqs.cgi method=post>\n";
	if ($config{'top_buttons'}) {
		if ($access{'mailq'} == 2) {
			print "<input type=submit value='$text{'mailq_delete'}'>\n";
			print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
			}
		print "<a href='' onClick='document.forms[0].file.checked = true; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
		print "<a href='' onClick='document.forms[0].file.checked = !document.forms[0].file.checked; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = !document.forms[0].file[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;<br>\n";
		}
	print "<table border width=100%>\n";
	print "<tr $tb> ";
	if ($access{'mailq'} == 2) {
		print "<td><br></td> ";
		}
	foreach $s (split(/,/, $config{'mailq_show'})) {
		$show{$s}++;
		}
	print "<td><b>$text{'mailq_id'}</b></td>\n";
	print "<td><b>$text{'mailq_sent'}</b></td>\n" if ($show{'Date'});
	print "<td><b>$text{'mailq_from'}</b></td>\n" if ($show{'From'});
        print "<td><b>$text{'mailq_to'}</b></td>\n" if ($show{'To'});
        print "<td><b>$text{'mailq_cc'}</b></td>\n" if ($show{'Cc'});
        print "<td><b>$text{'mailq_subject'}</b></td>\n" if ($show{'Subject'});
        print "<td><b>$text{'mailq_size'}</b></td>\n" if ($show{'Size'});
	print "<td><b>$text{'mailq_status'}</b></td>\n" if ($show{'Status'});
	print "</tr>\n";
	foreach $f (@qfiles) {
		($n = $f) =~ s/^.*\///;
		$from = $to = $date = $subject = $text{'mailq_unknown'};
		$cc = "&nbsp;";
		$status = $text{'mailq_sending'};
		open(QFILE, $f) || next;
		while(<QFILE>) {
			if (/^[^\-]*To:\s+(.*)/) { $to = $1; }
			elsif (/^[^\-]*From:\s+(.*)/) { $from = $1; }
			elsif (/^[^\-]*Date:\s+(.*)/) { $date = $1; }
			elsif (/^[^\-]*Subject:\s+(.*)/) { $subject = $1; }
			elsif (/^[^\-]*Cc:\s+(.*)/) { $cc = $1; }
			elsif (/^M(.*)/) { $status = $1; }
			}
		close(QFILE);
		$from =~ s/</&lt;/g; $from =~ s/>/&gt;/g;
		$to =~ s/</&lt;/g; $to =~ s/>/&gt;/g;
		$date =~ s/\+.*//g;
		($d = $f) =~ s/\/qf/\/df/;
		@st = stat($d);
		if ($st[7] > 1000000) {
			$size = int($st[7] / 1000000)." MB";
			}
		elsif ($st[7] > 1000) {
			$size = int($st[7] / 1000)." kB";
			}
		else {
			$size = "$st[7] b";
			}
		print "<tr $cb>\n";
		if ($access{'mailq'} == 2) {
			print "<td><input type=checkbox name=file ",
			      "value=$f></td>\n";
			print "<td><a href=\"view_mailq.cgi?",
			      "file=$f\">$n</a></td>\n";
			}
		else {
			print "<td><font size=1>$n</font></td>\n";
			}
		print "<td><font size=1>$date</font></td>\n" if ($show{'Date'});
		print "<td><font size=1>$from</font></td>\n" if ($show{'From'});
		print "<td><font size=1>$to</font></td>\n" if ($show{'To'});
		print "<td><font size=1>$cc</font></td>\n" if ($show{'Cc'});
		print "<td><font size=1>$subject</font></td>\n" if ($show{'Subject'});
		print "<td><font size=1>$size</font></td>\n" if ($show{'Size'});
		print "<td><font size=1>$status</font></td>\n" if ($show{'Status'});
		print "</tr>\n";
		}
	print "</table>\n";
	print "<a href='' onClick='document.forms[0].file.checked = true; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = true; } return false'>$text{'mail_all'}</a>&nbsp;\n";
	print "<a href='' onClick='document.forms[0].file.checked = !document.forms[0].file.checked; for(i=0; i<document.forms[0].file.length; i++) { document.forms[0].file[i].checked = !document.forms[0].file[i].checked; } return false'>$text{'mail_invert'}</a>&nbsp;<p>\n";
	if ($access{'mailq'} == 2) {
		print "<input type=submit value='$text{'mailq_delete'}'>\n";
		print "<input type=checkbox name=locked value=1> $text{'mailq_locked'}<p>\n";
		}
	print "</form>\n";
	print "<hr>\n";
	print "<table width=100%><tr><form action=flushq.cgi>\n";
	print "<td><input type=submit value='$text{'mailq_flush'}'></td>\n";
	print "<td>$text{'mailq_flushdesc'}</td>\n";
	print "</form></tr></table>\n";
	}
else {
	print "<b>$text{'mailq_none'}</b> <p>\n";
	}

print "<hr>\n";
&footer("", $text{'index_return'});

