# mailers-lib.pl
# Functions for editing the mailertable database

# mailers_dbm(&config)
# Returns the filename of the mailertable database and type, or undef if none
sub mailers_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^mailertable\s+(\S+)[^\/]+(\/\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# mailers_file(&config)
# Returns the filename of the text mailertable file, or undef if none
sub mailers_file
{
return &find_textfile($config{'mailers_file'}, &mailers_dbm($_[0]));
}

# list_mailers(textfile)
sub list_mailers
{
local($lnum, @rv);
$lnum = 0;
open(MAILER, $_[0]);
while(<MAILER>) {
	s/\r|\n//g;     # remove newlines
	s/#.*$//g;	# remove comments
	if (/^(\S+)\s+([^: ]+):(.*)/) {
		local(%virt);
		$virt{'domain'} = $1;
		$virt{'mailer'} = $2;
		$virt{'dest'} = $3;
		$virt{'line'} = $lnum;
		$virt{'num'} = scalar(@rv);
		push(@rv, \%virt);
		}
	$lnum++;
	}
close(MAILER);
return @rv;
}

# create_mailer(&details, textfile, dbmfile, dbmtype)
sub create_mailer
{
local(%mailer);
open(MAILER, ">> $_[1]");
print MAILER "$_[0]->{'domain'}\t$_[0]->{'mailer'}:$_[0]->{'dest'}\n";
close(MAILER);
if ($_[3] eq "dbm") {
	dbmopen(%mailer, $_[2], 0644);
	$mailer{$_[0]->{'domain'}} = "$_[0]->{'mailer'}:$_[0]->{'dest'}";
	dbmclose(%mailer);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# modify_mailer(&old, &details, textfile, dbmfile, dbmtype)
sub modify_mailer
{
local(@mailer, %mailer);
open(MAILER, $_[2]);
@mailer = <MAILER>;
close(MAILER);
splice(@mailer, $_[0]->{'line'}, 1,
       "$_[1]->{'domain'}\t$_[1]->{'mailer'}:$_[1]->{'dest'}\n");
open(MAILER, "> $_[2]");
print MAILER @mailer;
close(MAILER);
if ($_[3] eq "dbm") {
	dbmopen(%mailer, $_[3], 0644);
	delete($mailer{$_[0]->{'domain'}});
	$mailer{$_[1]->{'domain'}} = "$_[1]->{'mailer'}:$_[1]->{'dest'}";
	dbmclose(%mailer);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }
}

# delete_mailer(&old, textfile, dbmfile, dbmtype)
sub delete_mailer
{
local(@mailer, %mailer);
open(MAILER, $_[1]);
@mailer = <MAILER>;
close(MAILER);
splice(@mailer, $_[0]->{'line'}, 1);
open(MAILER, "> $_[1]");
print MAILER @mailer;
close(MAILER);
if ($_[3] eq "dbm") {
	dbmopen(%mailer, $_[2], 0644);
	delete($mailer{$_[0]->{'domain'}});
	dbmclose(%mailer);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# mailer_form([&details])
sub mailer_form
{
local($m, $mode, $addr, $conf, $ml, $dest, $nomx);
$m = $_[0];
print "<form action=save_mailer.cgi>\n";
if ($_[0]) { print "<input type=hidden name=num value=$m->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$_[0] ? $text{'mform_edit'} : $text{'mform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

$dom = $m->{'domain'} =~ /^\.(\S+)$/;
print "<tr> <td><b>$text{'mform_for'}</b></td>\n";
printf "<td><input type=radio name=from_type value=0 %s> %s</td>\n",
	$dom ? "" : "checked", $text{'mform_host'};
printf "<td><input name=from_host size=20 value=\"%s\"></td> </tr>\n",
	$dom ? "" : $m->{'domain'};
print "<tr> <td></td>\n";
printf "<td nowrap><input type=radio name=from_type value=1 %s> %s</td>\n",
	$dom ? "checked" : "", $text{'mform_domain'};
printf "<td><input name=from_dom size=20 value=\"%s\"></td> </tr>\n",
	$dom ? $1 : "";

print "<tr> <td><b>$text{'mform_delivery'}</b></td> ",
      "<td colspan=2><select name=mailer>\n";
$conf = &get_sendmailcf();
foreach $ml ( { 'value' => 'error' }, &find_type("M", $conf)) {
	$ml->{'value'} =~ /^([^ ,]+)/;
	printf "<option value=$1 %s>%s\n",
	    $m->{'mailer'} eq $1 || !$_[0] && $1 eq "smtp" ? "selected" : "",
	    $text{"mform_$1"} ? $text{"mform_$1"} : $1;
	}
print "</select></td> </tr>\n";

if ($m->{'dest'} =~ /^\[(\S+)\]$/) { $dest = $1; $nomx = 1; }
else { $dest = $m->{'dest'}; }
print "<tr> <td valign=top><b>$text{'mform_to'}</b></td>\n";
print "<td colspan=2><input name=dest size=30 value=\"$dest\"><br>\n";
printf "<input type=checkbox name=nomx value=1 %s>\n",
	$nomx ? "checked" : "";
print $text{'mform_ignore'},"\n";
print "</td> </tr>\n";

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value=\"$text{'save'}\">\n";
        print "<input type=submit name=delete value=\"$text{'delete'}\">\n";
        }
else { print "<input type=submit value=\"$text{'create'}\">\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

1;

