#!/usr/local/bin/perl
# Display a form for replying to an email

require './sendmail-lib.pl';
require './boxes-lib.pl';

&ReadParse();
&can_read_mail($in{'user'}) || &error($text{'reply_ecannot'});
if ($in{'new'}) {
	# Composing a new email
	&header($text{'compose_title'}, "");
	}
else {
	# Replying or forwarding
	if ($in{'mailforward'} ne '') {
		@mailforward = split(/\0/, $in{'mailforward'});
		@mails = &list_mails($in{'user'},
				     $mailforward[0], $mailforward[@mailforward-1]);
		$mail = $mails[$mailforward[0]];
		}
	else {
		@mails = &list_mails($in{'user'}, $in{'idx'}, $in{'idx'});
		$mail = $mails[$in{'idx'}];
		}

	if ($in{'delete'}) {
		# Just delete the email
		$gconfig{'logfiles'} = 0;
		&lock_file(&user_mail_file($in{'user'}));
		&delete_mail($in{'user'}, $mail);
		&unlock_file(&user_mail_file($in{'user'}));
		&redirect("list_mail.cgi?user=$in{'user'}");
		exit;
		}
	elsif ($in{'mark1'} || $in{'mark2'}) {
		# Just mark the message
		dbmopen(%read, "$module_config_directory/$in{'user'}.read",
			0600);
		$mode = $in{'mark1'} ? $in{'mode1'} : $in{'mode2'};
		if ($mode) {
			$read{$mail->{'header'}->{'message-id'}} = $mode;
			}
		else {
			delete($read{$mail->{'header'}->{'message-id'}});
			}
		$s = int((@mails - $in{'idx'} - 1) / $config{'perpage'}) *
		     $config{'perpage'};
		&redirect("list_mail.cgi?user=$in{'user'}&start=$s");
		exit;
		}

	if (!@mailforward) {
		&parse_mail($mail);
		@attach = @{$mail->{'attach'}};
		}

	if ($in{'strip'}) {
		# Remove all non-body attachments
		local $newmail = { 'headers' => $mail->{'headers'},
				   'header' => $mail->{'header'},
				   'fromline' => $mail->{'fromline'} };
		foreach $a (@attach) {
			if ($a->{'type'} eq 'text/plain' ||
			    $a->{'type'} eq 'text') {
				$newmail->{'attach'} = [ $a ];
				last;
				}
			}
		$gconfig{'logfiles'} = 0;
		&lock_file(&user_mail_file($in{'user'}));
		&modify_mail($in{'user'}, $mail, $newmail);
		&unlock_file(&user_mail_file($in{'user'}));
		&redirect("list_mail.cgi?user=$in{'user'}");
		exit;
		}

	&header($in{'forward'} || @mailforward ? $text{'forward_title'} :
		$in{'enew'} ? $text{'compose_title'} :
			      $text{'reply_title'}, "");

	if ($in{'enew'}) {
		$to = $mail->{'header'}->{'to'};
		$from = $mail->{'header'}->{'from'};
		$cc = $mail->{'header'}->{'cc'};
		$ouser = $1 if ($from =~ /^(\S+)\@/);
		}
	else {
		if (!$in{'forward'} && !@mailforward) {
			$to = $mail->{'header'}->{'reply-to'};
			$to = $mail->{'header'}->{'from'} if (!$to);
			}
		if ($in{'rall'}) {
			$cc = $mail->{'header'}->{'to'};
			$cc .= ", ".$mail->{'header'}->{'cc'}
				if ($mail->{'header'}->{'cc'});
			}
		}
	$subject = $mail->{'header'}->{'subject'};
	$subject = "Re: ".$subject if ($subject !~ /^Re/i && !$in{'forward'} &&
				       !@mailforward && !$in{'enew'});
	$subject = "Fwd: ".$subject if ($subject !~ /^Fwd/i &&
					($in{'forward'} || @mailforward));

	foreach $a (@attach) {
		if ($a->{'type'} eq 'text/plain') {
			$body = $a;
			if ($in{'enew'}) {
				$quote = $body->{'data'};
				}
			else {
				foreach $l (&wrap_lines($body->{'data'}, 70)) {
					$quote .= "> $l\n";
					}
				}
			last;
			}
		}
	$quote = &decode_mimewords($mail->{'header'}->{'from'}).
		 " wrote ..\n".$quote if ($quote && !$in{'enew'});
	if ($in{'forward'} || $in{'enew'}) {
		@attach = grep { $_ ne $body } @attach;
		}
	else {
		undef(@attach);
		}
	}
print "<hr>\n";

print "<form action=send_mail.cgi method=post enctype=multipart/form-data>\n";
print "<input type=hidden name=user value='$in{'user'}'>\n";
print "<input type=hidden name=ouser value='$ouser'>\n";
print "<input type=hidden name=idx value='$in{'idx'}'>\n";
print "<input type=hidden name=new value='$in{'new'}'>\n";

print "<table width=100% border=1>\n";
print "<tr> <td $tb><b>$text{'reply_headers'}</b></td> </tr>\n";
print "<tr> <td $cb><table width=100%>\n";
print "<tr> <td><b>$text{'mail_from'}</b></td>\n";
if ($access{'fmode'} == 0) {
	$from = $in{'user'}.'@'.&from_hostname() if (!$from);
	print "<td><input name=from size=40 value='$from'></td>\n";
	}
elsif ($access{'fmode'} == 1) {
	local $u = $ouser ? $ouser : $in{'user'};
	print "<td><select name=from>\n";
	foreach $f (split(/\s+/, $access{'from'})) {
		printf "<option value=%s %s>%s\n",
		    "$u\@$f", $from eq "$u\@$f" ? 'selected' : '',
		    $access{'fromname'} ?
			"\"$access{'fromname'}\" &lt;$u\@$f&gt;" : "$u\@$f";
		}
	print "</select></td>\n";
	}
elsif ($access{'fmode'} == 2) {
	print "<td><select name=from>\n";
	foreach $f (split(/\s+/, $access{'from'})) {
		printf "<option value=%s %s>%s\n",
		    $f, $from eq $f ? 'selected' : '',
		    $access{'fromname'} ? "$access{'fromname'} &lt;$f&gt;" : $f;
		}
	print "</select></td>\n";
	}
elsif ($access{'fmode'} == 3) {
	print "<td><input name=from size=10>$ouser\@$access{'from'}</td>\n";
	}
$to =~ s/"/&quot;/g;
print "<td><b>$text{'mail_to'}</b></td> ",
      "<td><input name=to size=40 value=\"$to\"></td> </tr>\n";
$cc =~ s/"/&quot;/g;
print "<tr> <td><b>$text{'mail_cc'}</b></td> ",
      "<td><input name=cc size=40 value=\"$cc\"></td>\n";
print "<td><b>$text{'mail_bcc'}</b></td> ",
      "<td><input name=bcc size=40 value=''></td> </tr>\n";
$subject =~ s/"/&quot;/g;
print "<tr> <td><b>$text{'mail_subject'}</b></td> ",
      "<td><input name=subject size=40 value=\"$subject\"></td>\n";
print "<td><b>$text{'mail_pri'}</b></td> ",
      "<td><table cellpadding=0 cellspacing=0 width=100%>\n",
      "<tr><td align=left><select name=pri>\n",
      "<option value=1>$text{'mail_highest'}\n",
      "<option value=2>$text{'mail_high'}\n",
      "<option value='' selected>$text{'mail_normal'}\n",
      "<option value=4>$text{'mail_low'}\n",
      "<option value=5>$text{'mail_lowest'}\n",
      "</select></td>\n",
      "<td align=right><input type=submit value=\"$text{'reply_send'}\"></td>\n",
      "</tr></table></td></tr>\n";
print "</table></td></tr></table><p>\n";

print "<table width=100% border=1><tr><td $cb>",
      "<textarea rows=20 cols=80 name=body $config{'wrap_mode'}>",$quote,
      "</textarea></td></tr></table><p>\n";

# Display forwarded attachments
if (@attach) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'reply_attach'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $a (@attach) {
		push(@titles, "<input type=checkbox name=forward value=$a->{'idx'} checked> ".($a->{'filename'} ? $a->{'filename'} : $a->{'type'}));
		push(@links, "detach.cgi?user=$in{'user'}&idx=$in{'idx'}&attach=$a->{'idx'}");
		push(@icons, "images/boxes.gif");
		}
	&icons_table(\@links, \@titles, \@icons, 8);
	print "</td></tr></table><p>\n";
	}

# Display forwarded mails
if (@mailforward) {
	print "<table width=100% border=1>\n";
	print "<tr> <td $tb><b>$text{'reply_mailforward'}</b></td> </tr>\n";
	print "<tr> <td $cb>\n";
	foreach $f (@mailforward) {
		push(@titles, &simplify_subject($mails[$f]->{'header'}->{'subject'}));
		push(@links, "view_mail.cgi?user=$in{'user'}&idx=$f");
		push(@icons, "images/boxes.gif");
		print "<input type=hidden name=mailforward value=$f>\n";
		}
	&icons_table(\@links, \@titles, \@icons, 8);
	print "</td></tr></table><p>\n";
	}

# Add form for more attachments
print "<table width=100% border=1>\n";
print "<tr $tb> <td colspan=3><b>$text{'reply_attach2'}</b></td> </tr>\n";

print "<tr $cb> <td><input type=file size=20 name=attach0></td>\n";
print "<td><input type=file size=20 name=attach1></td>\n";
print "<td><input type=file size=20 name=attach2></td> </tr>\n";

print "<tr $cb> <td><input type=file size=20 name=attach3></td>\n";
print "<td><input type=file size=20 name=attach4></td>\n";
print "<td><input type=file size=20 name=attach5></td> </tr>\n";

if ($access{'canattach'}) {
	print "<tr $cb> <td><input name=file0 size=20> ",
		&file_chooser_button("file0"),"</td>\n";
	print "<td><input name=file1 size=20> ",
		&file_chooser_button("file1"),"</td>\n";
	print "<td><input name=file2 size=20> ",
		&file_chooser_button("file2"),"</td> </tr>\n";
	}

print "</table><p>\n";
print "<input type=submit value=\"$text{'reply_send'}\"></form>\n";

print "<hr>\n";
&footer("list_mail.cgi?user=$in{'user'}", $text{'mail_return'});

