#!/usr/local/bin/perl
# edit_delay.cgi
# Displays a list of existing delay pools

require './squid-lib.pl';
$access{'delay'} || &error($text{'delay_ecannot'});
&header($text{'delay_title'}, "", "edit_delay", 0, 0, 0, &restart_button());
print "<hr>\n";
$conf = &get_config();

# Display all known delay pools
$pools = &find_value("delay_pools", $conf);
if ($pools) {
	@pools = sort { $a->{'values'}->[0] <=> $b->{'values'}->[0] }
		      &find_config("delay_class", $conf);
	@params = &find_config("delay_parameters", $conf);
	print "<a href='edit_pool.cgi?new=1'>$text{'delay_add'}</a><br>\n";
	print "<table border>\n";
	print "<tr $tb> <td><b>$text{'delay_num'}</b></td> ",
	      "<td><b>$text{'delay_class'}</b></td> ",
	      "<td><b>$text{'delay_agg'}</b></td> ",
	      "<td><b>$text{'delay_ind'}</b></td> ",
	      "<td><b>$text{'delay_net'}</b></td> </tr>\n";
	foreach $p (@pools) {
		local ($pr) = grep { $_->{'values'}->[0] ==
				     $p->{'values'}->[0] } @params;
		print "<tr $cb>\n";
		print "<td><a href='edit_pool.cgi?idx=$p->{'values'}->[0]'>",
		      "$p->{'values'}->[0]</a></td>\n";
		print "<td>",$text{"delay_class_$p->{'values'}->[1]"},"</td>\n";
		print "<td>",&pool_param($pr->{'values'}->[1]),"</td>\n";
		if ($p->{'values'}->[1] == 2) {
			print "<td>",&pool_param(
					$pr->{'values'}->[2]),"</td>\n";
			print "<td><br></td>\n";
			}
		else {
			print "<td>",&pool_param(
					$pr->{'values'}->[3]),"</td>\n";
			print "<td>",&pool_param(
					$pr->{'values'}->[2]),"</td>\n";
			}
		print "</tr>\n";
		}
	print "</table>\n";
	}
else {
	print "<b>$text{'delay_none'}</b><p>\n";
	}
print "<a href='edit_pool.cgi?new=1'>$text{'delay_add'}</a><p>\n";

print "<form action=save_delay.cgi>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'delay_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

print "<tr>\n";
print &opt_input($text{'delay_initial'}, "delay_initial_bucket_level", $conf,
		 $text{'default'}, 4, "%");
print "<td colspan=2 width=50%></td>\n";
print "</tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'save'}'></form>\n";

print "<hr>\n";
&footer("", $text{'eicp_return'});

# pool_param(param)
sub pool_param
{
if ($_[0] =~ /^([0-9\-]+)\/([0-9\-]+)$/) {
	return $1 == -1 ? $text{'delay_unlimited'} :
		&text('delay_param', "$1", "$2");
	}
else {
	return $_[0];	# huh?
	}
}

