#!/usr/local/bin/perl
# save_log.cgi
# Save, create, delete or view a log

require './syslog-lib.pl';
&ReadParse();
&foreign_require("proc", "proc-lib.pl");
$conf = &get_config();

if ($in{'delete'}) {
	# Deleting a log 
	&lock_file($config{'syslog_conf'});
	$access{'noedit'} && &error($text{'edit_ecannot'});
	$log = $conf->[$in{'idx'}];
	&delete_log($log);
	&unlock_file($config{'syslog_conf'});
	&redirect("");
	}
elsif ($in{'view'}) {
	# Viewing a log file
	$log = $conf->[$in{'idx'}];
	&header($text{'view_title'}, "");
	print "<hr>\n";

	print "<form action=save_log.cgi>\n";
	print "<input type=hidden name=idx value='$in{'idx'}'>\n";
	print "<input type=hidden name=view value=1>\n";
	$lines = $in{'lines'} ? int($in{'lines'}) : $config{'lines'};

	$| = 1;
	print "<pre>";
	$got = &foreign_call("proc", "safe_process_exec",
		      "tail -$lines $log->{'file'}", 0, 0, STDOUT, undef, 1);
	print "<i>$text{'view_empty'}</i>\n" if (!$got);
	print "</pre>\n";
	print &text('view_header', "<input name=lines size=3 value='$lines'>",
		    "<tt>".&html_escape($log->{'file'})."</tt>"),"\n";
	print "&nbsp;&nbsp;\n";
	print "<input type=submit value='$text{'view_refresh'}'><br>\n";

	print "</form><hr>\n";
	&footer($access{'noedit'} ? () : ( "edit_log.cgi?idx=$in{'idx'}", $text{'edit_return'} ), "", $text{'index_return'});
	exit;
	}
else {
	# saving or updating a log
	&lock_file($config{'syslog_conf'});
	$access{'noedit'} && &error($text{'edit_ecannot'});
	&error_setup($text{'save_err'});

	# Validate destination section
	if ($in{'mode'} == 0) {
		open(FILE, ">>$in{'file'}") ||
			&error(&text('save_efile', $in{'file'}, $!));
		close(FILE);
		system("chmod go-wx $in{'file'}");
		$log->{'file'} = $in{'file'};
		$log->{'sync'} = $in{'sync'};
		}
	elsif ($in{'mode'} == 1 && $config{'pipe'} == 1) {
		-w $in{'pipe'} || &error(&text('save_epipe', $in{'pipe'}));
		$log->{'pipe'} = $in{'pipe'};
		}
	elsif ($in{'mode'} == 1 && $config{'pipe'} == 2) {
		$in{'pipe'} || &error($text{'save_epipe2'});
		$log->{'pipe'} = $in{'pipe'};
		}
	elsif ($in{'mode'} == 2) {
		gethostbyname($in{'host'}) ||
			&error(&text('save_ehost', $in{'host'}));
		$log->{'host'} = $in{'host'};
		}
	elsif ($in{'mode'} == 3) {
		@users = split(/\s+/, $in{'users'});
		@users || &error($text{'save_enousers'});
		foreach $u (@users) {
			defined(getpwnam($u)) ||
				&error(&text('save_euser', $u));
			}
		$log->{'users'} = \@users;
		}
	elsif ($in{'mode'} == 5) {
		-S $in{'socket'} || &error($text{'save_esocket'});
		$log->{'socket'} = $in{'socket'};
		}
	else {
		$log->{'all'} = 1;
		}
	$log->{'active'} = $in{'active'};
	if ($config{'tags'} && $in{'tag'} ne '') {
		$log->{'section'} = $conf->[$in{'tag'}];
		}

	# Parse message types section
	for($i=0; defined($in{"fmode_$i"}); $i++) {
		local ($f, $p);
		if ($in{"fmode_$i"} == 0) {
			next if (!$in{"facil_$i"});
			$f = $in{"facil_$i"};
			}
		else {
			@facils = split(/\s+/, $in{"facils_$i"});
			@facils || &error($text{'save_efacils'});
			$f = join(",", @facils);
			}
		if ($in{"pmode_$i"} == 0) {
			$p = 'none';
			}
		elsif ($in{"pmode_$i"} == 1) {
			$p = '*';
			}
		else {
			$p = $in{"pdir_$i"}.$in{"pri_$i"};
			$in{"pri_$i"} || &error($text{'save_epri'});
			}
		push(@sel, "$f.$p");
		}
	@sel || &error($text{'save_esel'});
	$log->{'sel'} = \@sel;
	if ($in{'new'}) {
		&create_log($log);
		}
	else {
		$old = $conf->[$in{'idx'}];
		&update_log($old, $log);
		}
	&unlock_file($config{'syslog_conf'});
	&redirect("");
	}
&log_line($log) =~ /(\S+)$/;
&webmin_log($in{'delete'} ? "delete" :
	    $in{'new'} ? "create" : "modify", "log", "$1", $log);

