#!/usr/local/bin/perl
# batch_exec.cgi
# Execute create/modify/delete commands in a batch file

require './user-lib.pl';
%access = &get_module_acl();
$access{'batch'} || &error($text{'batch_ecannot'});
if ($ENV{'REQUEST_METHOD'} eq 'GET') {
	&ReadParse();
	}
else {
	&ReadParseMime();
	}
if ($in{'file'}) {
	$data = $in{'file'};
	}
elsif ($in{'local'}) {
	open(LOCAL, $in{'local'}) || &error($text{'batch_elocal'});
	while(<LOCAL>) {
		$data .= $_;
		}
	close(LOCAL);
	}
else {
	&error($text{'batch_efile'});
	}

&header($text{'batch_title'}, "");
print "<hr>\n";
$| = 1;

# Force defaults for save options
$in{'makehome'} = 1 if (!$access{'makehome'});
$in{'copy'} = 1 if (!$access{'copy'} && $config{'user_files'} =~ /\S/);
$in{'others'} = 1 if (!$access{'cothers'} && !$access{'mothers'});
$in{'movehome'} = 1 if (!$access{'movehome'});
$in{'chuid'} = 1 if (!$access{'chuid'});
$in{'chgid'} = 1 if (!$access{'chgid'});

# Work out a good base UID for new users
&my_setpwent();
while(@tmp = &my_getpwent()) {
	$used{$tmp[2]}++;
	$taken{$tmp[0]}++;
	}
&my_endpwent();
$newuid = int($config{'base_uid'} > $access{'lowuid'} ?
	      $config{'base_uid'} : $access{'lowuid'});

# Work out a good base GID for new groups
&my_setgrent();
while(@tmp = &my_getgrent()) {
	$gused{$tmp[2]}++;
	$used{$tmp[2]}++ if ($config{'new_user_gid'});
	$gtaken{$tmp[0]}++;
	}
&my_endgrent();
$newgid = int($config{'base_gid'} > $access{'lowgid'} ?
	      $config{'base_gid'} : $access{'lowgid'});
@glist = &list_groups();

# Process the file
$lnum = $created = $modified = $deleted = 0;
print "<pre>\n";
$pft = &passfiles_type();
foreach $line (split(/[\r\n]+/, $data)) {
	&lock_user_files();
	$lnum++;
	$line =~ s/#.*$//;
	next if ($line !~ /\S/);
	local @line = split(/:/, $line, -1);
	local %user;
	if ($line[0] eq 'create') {
		# Creating a new user
		if ($pft == 5) {
			# Openserver passwd and short shadow information
			if (@line != 10) {
				print &text('batch_elen', $lnum, 10),"\n";
				next;
				}
			$user{'min'} = $line[8];
			$user{'max'} = $line[9];
			}
		elsif ($pft == 4) {
			# AIX passwd and security information
			if (@line != 12) {
				print &text('batch_elen', $lnum, 12),"\n";
				next;
				}
			$user{'min'} = $line[8];
			$user{'max'} = $line[9];
			$user{'expire'} = $line[10];
			map { $user{$_}++ } split(/\s+/, $line[11]);
			}
		elsif ($pft == 2) {
			# SYSV-style passwd and shadow information
			if (@line != 13) {
				print &text('batch_elen', $lnum, 13),"\n";
				next;
				}
			$user{'min'} = $line[8];
			$user{'max'} = $line[9];
			$user{'warn'} = $line[10];
			$user{'inactive'} = $line[11];
			$user{'expire'} = $line[12];
			$user{'change'} = int(time() / (60*60*24));
			}
		elsif ($pft == 1 || $pft == 6) {
			# BSD master.passwd information
			if (@line != 11) {
				print &text('batch_elen', $lnum, 11),"\n";
				next;
				}
			$user{'class'} = $line[8];
			$user{'change'} = $line[9];
			$user{'expire'} = $line[10];
			}
		else {
			# Classic passwd file information
			if (@line != 8) {
				print &text('batch_elen', $lnum, 8),"\n";
				next;
				}
			}

		# Parse common fields
		if (!$line[1]) {
			print &text('batch_eline', $lnum),"\n";
			next;
			}
		$user{'user'} = $line[1];
		if ($config{'max_length'} &&
		    length($in{'user'}) > $config{'max_length'}) {
			print &text('batch_elength', $lnum, $user{'user'}),"\n";
			next;
			}
		if ($taken{$user{'user'}}) {
			print &text('batch_euser', $lnum, $user{'user'}),"\n";
			next;
			}
		if ($line[3] !~ /^\d+$/) {
			# make up a UID
			while($used{$newuid}) {
				$newuid++;
				}
			$user{'uid'} = $newuid;
			}
		else {
			# use the given UID
			if ($used{$line[3]} && !$access{'umultiple'}) {
				print &text('batch_ecaccess', $lnum,
					    $text{'usave_euidused2'}),"\n";
				next;
				}
			$user{'uid'} = $line[3];
			}
		$used{$user{'uid'}}++;
		if ($access{'autohome'}) {
			# Assign home dir automatically
			$user{'home'} = &auto_home_dir($access{'home'},
						       $user{'user'});
			}
		else {
			# Use given home dir
			if ($line[6] !~ /^\//) {
				print &text('batch_ehome', $lnum,$line[6]),"\n";
				next;
				}
			$user{'home'} = $line[6];
			}
		if (!-r $line[7]) {
			print &text('batch_eshell', $lnum, $line[7]),"\n";
			next;
			}
		$user{'shell'} = $line[7];
		$user{'real'} = $line[5];
		local @gids = split(/[ ,]+/, $line[4]);
		$user{'gid'} = $gids[0];

		# Check access control restrictions
		if (!$access{'ucreate'}) {
			print &text('batch_ecaccess', $lnum,
				    $text{'usave_ecreate'});
			next;
			}
		local $ch = &check_user(\%user);
		if ($ch) {
			print &text('batch_ecaccess', $lnum, $ch),"\n";
			next;
			}

		# Run the before command
		$ENV{'USERADMIN_USER'} = $user{'user'};
		$ENV{'USERADMIN_UID'} = $user{'uid'};
		$ENV{'USERADMIN_REAL'} = $user{'real'};
		$ENV{'USERADMIN_SHELL'} = $user{'shell'};
		$ENV{'USERADMIN_HOME'} = $user{'home'};
		$ENV{'USERADMIN_GID'} = $user{'gid'};
		$ENV{'USERADMIN_PASS'} = $user{'plainpass'};
		$ENV{'USERADMIN_ACTION'} = 'CREATE_USER';
		$ENV{'USERADMIN_SECONDARY'} = '';	# not added to any
		$merr = &making_changes();
		&error(&text('usave_emaking', "<tt>$merr</tt>"))
			if (defined($merr));

		if ($user{'gid'} !~ /^\d+$/) {
			# Need to create a new group for the user
			if (!$access{'gcreate'}) {
				print &text('batch_ecaccess', $lnum,
					    $text{'usave_egcreate'}),"\n";
				next;
				}
			if ($gtaken{$user{'user'}}) {
				print &text('batch_egtaken', $lnum,
					    $user{'user'}),"\n";
				next;
				}

			if ($config{'new_user_gid'}) {
				$newgid = $user{'uid'};
				}
			else {
				while($gused{$newgid}) {
					$newgid++;
					}
				}
			local %group;
			$group{'group'} = $user{'user'};
			$user{'gid'} = $group{'gid'} = $newgid;
			&create_group(\%group);
			$gused{$group{'gid'}}++;
			}

		# Create the user!
		if ($in{'makehome'} && !-d $user{'home'}) {
			&lock_file($user{'home'});
			if (!mkdir($user{'home'}, oct($config{'homedir_perms'}))) {
				print &text('batch_emkdir', $user{'home'}, $!),"\n";
				}
			chmod(oct($config{'homedir_perms'}), $user{'home'});
			chown($user{'uid'}, $user{'gid'}, $user{'home'});
			&unlock_file($user{'home'});
			}
		if ($in{'crypt'}) {
			$user{'pass'} = $line[2];
			$user{'passmode'} = 2;
			}
		elsif ($line[2] eq 'x') {
			# No login allowed
			$user{'pass'} = $config{'lock_string'};
			$user{'passmode'} = 1;
			}
		elsif ($line[2] eq '') {
			# No password needed
			$user{'pass'} = '';
			$user{'passmode'} = 0;
			}
		else {
			# Normal password
			#$salt = chr(int(rand(26))+65) . chr(int(rand(26))+65);
			#$user{'pass'} = crypt($line[2], $salt);
			$user{'pass'} = &encrypt_password($line[2]);
			$user{'passmode'} = 3;
			$user{'plainpass'} = $line[2];
			}
		&create_user(\%user);

		# Add user to some secondary groups
		if (@gids > 1) {
			local $i;
			for($i=1; $i<@gids; $i++) {
				local ($group) =
				    grep { $_->{'gid'} eq $gids[$i] } @glist;
				next if (!$group);
				local @mems = split(/,/ , $group->{'members'});
				push(@mems, $user{'user'});
				$group->{'members'} = join(",", @mems);
				&modify_group($group, $group);
				}
			}

		# All done
		&unlock_user_files();
		&made_changes();
		&other_modules("useradmin_create_user", \%user)
			if ($in{'others'});

		if ($in{'copy'} && $in{'makehome'}) {
			# Copy files to user's home directory
			local $uf = $config{'user_files'};
			local $shell = $user{'shell'}; $shell =~ s/^(.*)\///g;
			if ($group = &my_getgrgid($user{'gid'})) {
				$uf =~ s/\$group/$group/g;
				}
			$uf =~ s/\$gid/$user{'gid'}/g;
			$uf =~ s/\$shell/$shell/g;
			&copy_skel_files($uf, $user{'home'},
					 $user{'uid'}, $user{'gid'});
			}

		print "<b>",&text('batch_created',$user{'user'}),"</b>\n";
		$created++;
		}
	elsif ($line[0] eq 'delete') {
		# Deleting an existing user
		if (@line != 2) {
			print &text('batch_elen', $lnum, 2),"\n";
			next;
			}
		local @ulist = &list_users();
		local ($user) = grep { $_->{'user'} eq $line[1] } @ulist;
		if (!$user) {
			print &text('batch_enouser', $lnum, $line[1]),"\n";
			next;
			}
		%user = %$user;
		if (!&can_edit_user(\%access, \%user)) {
			print &text('batch_edaccess', $lnum,
				    $text{'udel_euser'}),"\n";
			next;
			}

		# Run the before command
		$ENV{'USERADMIN_USER'} = $user{'user'};
		$ENV{'USERADMIN_UID'} = $user{'uid'};
		$ENV{'USERADMIN_REAL'} = $user{'real'};
		$ENV{'USERADMIN_SHELL'} = $user{'shell'};
		$ENV{'USERADMIN_HOME'} = $user{'home'};
		$ENV{'USERADMIN_GID'} = $user{'gid'};
		$ENV{'USERADMIN_SECONDARY'} = join(",", &secondary_groups(
							 $user{'user'}));
		$ENV{'USERADMIN_ACTION'} = 'DELETE_USER';
		$merr = &making_changes();
		&error(&text('usave_emaking', "<tt>$merr</tt>"))
			if (defined($merr));

		# Delete the user entry
		&other_modules("useradmin_delete_user", \%user)
			if ($in{'others'});
		&delete_user(\%user);

		# Delete the user from groups
		foreach $g (&list_groups()) {
			@mems = split(/,/, $g->{'members'});
			$idx = &indexof($user{'user'}, @mems);
			if ($idx >= 0) {
				splice(@mems, $idx, 1);
				%newg = %$g;
				$newg{'members'} = join(',', @mems);
				&modify_group($g, \%newg);
				}
			$mygroup = $g if ($g->{'group'} eq $user{'user'});
			}

		# Delete the user's group
		if ($mygroup && !$mygroup->{'members'}) {
			local $another;
			foreach $ou (&list_users()) {
				$another++
					if ($ou->{'gid'} == $mygroup->{'gid'});
				}
			if (!$another) {
				&delete_group($mygroup);
				}
			}
		&unlock_user_files();
		&made_changes();

		# Delete his home directory
		if ($in{'delhome'} && $user{'home'} !~ /^\/+$/) {
			if ($config{'delete_only'}) {
				&lock_file($user{'home'});
				&system_logged("find \"$user{'home'}\" ! -type d -user $user{'uid'} | xargs rm -f >/dev/null 2>&1");
				&system_logged("find \"$user{'home'}\" -type d -user $user{'uid'} | xargs rmdir >/dev/null 2>&1");
				rmdir($user{'home'});
				&unlock_file($user{'home'});
				}
			else {
				&system_logged("rm -rf \"$user{'home'}\" >/dev/null 2>&1");
				}
			}

		print "<b>",&text('batch_deleted',$user{'user'}),"</b>\n";
		$deleted++;
		}
	elsif ($line[0] eq 'modify') {
		# Modifying an existing user
		local $wlen = $pft == 5 ? 11 :
			      $pft == 4 ? 13 :
			      $pft == 2 ? 14 :
			      $pft == 1 || $pft == 6 ? 12 : 9;
		if (@line != $wlen) {
			print &text('batch_elen', $lnum, $wlen),"\n";
			next;
			}
		local @ulist = &list_users();
		local ($user) = grep { $_->{'user'} eq $line[1] } @ulist;
		if (!$user) {
			print &text('batch_enouser', $lnum, $line[1]),"\n";
			next;
			}
		%olduser = %user = %$user;
		$user{'olduser'} = $user->{'user'};
		if (!&can_edit_user(\%access, \%user)) {
			print &text('batch_emaccess', $lnum,
				    $text{'usave_eedit'}),"\n";
			next;
			}

		# Update supplied fields
		$user{'user'} = $line[2] if ($line[2] ne '');
		if ($in{'crypt'} && $line[3] ne '') {
			# Changing to pre-encrypted password
			$user{'pass'} = $line[3];
			$user{'passmode'} = 2;
			}
		elsif ($line[3] eq 'x') {
			# No login allowed
			$user{'pass'} = $config{'lock_string'};
			$user{'passmode'} = 1;
			}
		elsif ($line[3] ne '') {
			# Normal password
			$user{'pass'} = &encrypt_password($line[3]);
			$user{'passmode'} = 3;
			$user{'plainpass'} = $line[3];
			}
		else {
			# No change
			$user{'passmode'} = 4;
			}
		$user{'uid'} = $line[4] if ($line[4] ne '');
		$user{'gid'} = $line[5] if ($line[5] ne '');
		$user{'real'} = $line[6] if ($line[6] ne '');
		$user{'home'} = $line[7] if ($line[7] ne '');
		$user{'shell'} = $line[8] if ($line[8] ne '');
		if ($access{'peopt'}) {
			if ($pft == 5) {
				# Openserver password and short shadow
				$user{'min'}=$line[9] if ($line[9] ne '');
				$user{'max'}=$line[10] if ($line[10] ne '');
				$user{'change'}=int(time() / (60*60*24))
					if ($line[3] ne '');
				}
			elsif ($pft == 4) {
				# AIX password and security information
				$user{'min'}=$line[9] if ($line[9] ne '');
				$user{'max'}=$line[10] if ($line[10] ne '');
				$user{'expire'}=$line[11] if ($line[11] ne '');
				if ($line[12] ne '') {
					delete($user{'admin'});
					delete($user{'admchg'});
					delete($user{'nocheck'});
					map { $user{$_}++ }
					    split(/\s+/, $line[12]);
					}
				$user{'change'}=time() if ($line[3] ne '');
				}
			elsif ($pft == 2) {
				# SYSV-style passwd and shadow information
				$user{'min'}=$line[9] if ($line[9] ne '');
				$user{'max'}=$line[10] if ($line[10] ne '');
				$user{'warn'}=$line[11] if ($line[11] ne '');
				$user{'inactive'}=$line[12]
					if ($line[12] ne '');
				$user{'expire'}=$line[13] if ($line[13] ne '');
				$user{'change'}=int(time() / (60*60*24))
					if ($line[3] ne '');
				}
			elsif ($pft == 1 || $pft == 6) {
				# BSD master.passwd information
				$user{'class'}=$line[9] if ($line[9] ne '');
				$user{'change'}=$line[10] if ($line[10] ne '');
				$user{'expire'}=$line[11] if ($line[11] ne '');
				}
			}

		# Check access control restrictions
		local $ch = &check_user(\%user, \%olduser);
		if ($ch) {
			print &text('batch_emaccess', $lnum, $ch),"\n";
			next;
			}

		# Run the before command
		$ENV{'USERADMIN_USER'} = $user{'user'};
		$ENV{'USERADMIN_UID'} = $user{'uid'};
		$ENV{'USERADMIN_REAL'} = $user{'real'};
		$ENV{'USERADMIN_SHELL'} = $user{'shell'};
		$ENV{'USERADMIN_HOME'} = $user{'home'};
		$ENV{'USERADMIN_GID'} = $user{'gid'};
		$ENV{'USERADMIN_PASS'} = $user{'plainpass'};
		$ENV{'USERADMIN_SECONDARY'} = join(",", &secondary_groups(
							 $user{'user'}));
		$ENV{'USERADMIN_ACTION'} = 'MODIFY_USER';
		$merr = &making_changes();
		&error(&text('usave_emaking', "<tt>$merr</tt>"))
			if (defined($merr));

		# Move home directory if needed
		if ($olduser{'home'} ne $user{'home'} && $in{'movehome'} &&
		    $user{'home'} ne '/' && $olduser{'home'} ne '/') {
			if (-d $olduser{'home'} && !-e $user{'home'}) {
				local $out = &backquote_logged(
					"mv \"$olduser{'home'}\" ".
					"\"$user{'home'}\" 2>&1");
				if ($?) { &error(&text('batch_emove',
						 $lnum, $out)); }
				}
			}

		# Change UIDs and GIDs?
		if ($olduser{'gid'} != $user{'gid'} && $in{'chgid'}) {
			if ($in{'chgid'} == 1) {
				&recursive_change($user{'home'},$olduser{'uid'},
					  $olduser{'gid'}, -1, $user{'gid'});
				}
			else {
				&recursive_change("/", $olduser{'uid'},
					  $olduser{'gid'}, -1, $user{'gid'});
				}
			}
		if ($olduser{'uid'} != $user{'uid'} && $in{'chuid'}) {
			if ($in{'chuid'} == 1) {
				&recursive_change($user{'home'},$olduser{'uid'},
						  -1, $user{'uid'}, -1);
				}
			else {
				&recursive_change("/", $olduser{'uid'},
						  -1, $user{'uid'}, -1);
				}
			}

		# Actually modify the user
		&modify_user(\%olduser, \%user);
		&unlock_user_files();
		&made_changes();
		&other_modules("useradmin_modify_user", \%user, \%olduser)
			if ($in{'others'});

		print "<b>",&text('batch_modified',$olduser{'user'}),"</b>\n";
		$modified++;
		}
	else {
		print &text('batch_eaction', $lnum, $line[0]),"\n";
		next;
		}
	}
print "</pre>\n";
&unlock_user_files();
&webmin_log("batch", undef, $in{'local'} ? $in{'local'} : undef,
	    { 'created' => $created, 'modified' => $modified,
	      'deleted' => $deleted, 'lnum' => $lnum } );

print "<hr>\n";
&footer("batch_form.cgi", $text{'batch_return'},
	"", $text{'index_return'});

# check_user(\%user, [\%olduser])
# Check access control restrictions for a user
sub check_user
{
# check if uid is within range
if ($access{'lowuid'} && $_[0]->{'uid'} < $access{'lowuid'}) {
	return &text('usave_elowuid', $access{'lowuid'});
	}
if ($access{'hiuid'} && $_[0]->{'uid'} > $access{'hiuid'}) {
	return &text('usave_ehiuid', $access{'hiuid'});
	}
if ($_[1] && !$access{'uuid'} && $_[1]->{'uid'} != $_[0]->{'uid'}) {
	return $text{'usave_euuid'};
	}

# make sure home dir is under the allowed root
if (!$access{'autohome'}) {
	$al = length($access{'home'});
	if (length($_[0]->{'home'}) < $al ||
	    substr($_[0]->{'home'}, 0, $al) ne $access{'home'}) {
		return &text('usave_ehomepath', $_[0]->{'home'});
		}
	}

# check for invalid shell
if ($access{'shells'} ne '*' &&
    &indexof($_[0]->{'shell'}, split(/\s+/, $access{'shells'})) < 0) {
	return &text('usave_eshell', $_[0]->{'shell'});
	}

# check for invalid primary group (unless one is dynamically assigned)
if ($user{'gid'} ne '') {
	local $ng = &my_getgrgid($_[0]->{'gid'});
	local $ni = &can_use_group(\%access, $ng);
	if ($_[1]) {
		if ($_[1]->{'gid'} != $_[0]->{'gid'}) {
			local $og = &my_getgrgid($_[1]->{'gid'});
			local $oi = &can_use_group(\%access, $og);
			if (!$ni) { return &text('usave_eprimary', $ng); }
			if (!$oi) { return &text('usave_eprimaryr', $og); }
			}
		}
	else {
		return &text('usave_eprimary', $ng) if (!$ni);
		}
	}
return undef;
}

sub secondary_groups
{
local @secs;
foreach $g (@glist) {
	@mems = split(/,/, $g->{'members'});
	if (&indexof($_[0], @mems) >= 0) {
		push(@secs, $g->{'gid'});
		}
	}
return @secs;
}

