#!/usr/local/bin/perl
# delete_user.cgi
# Delete a user, after asking for confirmation

require './user-lib.pl';
&ReadParse();
&lock_user_files();
@ulist = &list_users();
%user = %{$ulist[$in{'num'}]};
&error_setup($text{'udel_err'});
%access = &get_module_acl();
&can_edit_user(\%access, \%user) || &error($text{'udel_euser'});

$| = 1;
&header($text{'udel_title'}, "");
print "<hr>\n";
if ($in{'confirmed'}) {
	# Check for repeat click
	if ($user{'user'} ne $in{'user'}) {
		print "<b>$text{'udel_ealready'}</b>. <p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}

	# Run the before command
	$ENV{'USERADMIN_USER'} = $user{'user'};
	$ENV{'USERADMIN_UID'} = $user{'uid'};
	$ENV{'USERADMIN_REAL'} = $user{'real'};
	$ENV{'USERADMIN_SHELL'} = $user{'shell'};
	$ENV{'USERADMIN_HOME'} = $user{'home'};
	$ENV{'USERADMIN_GID'} = $user{'gid'};
	$ENV{'USERADMIN_ACTION'} = 'DELETE_USER';
	local @secs;
	foreach $g (&list_groups()) {
		@mems = split(/,/, $g->{'members'});
		if (&indexof($user{'user'}, @mems) >= 0) {
			push(@secs, $g->{'gid'});
			}
		}
	$ENV{'USERADMIN_SECONDARY'} = join(",", @secs);
	$merr = &making_changes();
	&error(&text('usave_emaking', "<tt>$merr</tt>")) if (defined($merr));

	# Go ahead and do it!
	if ($in{'others'}) {
		print "$text{'udel_other'}<br>\n";
		&other_modules("useradmin_delete_user", \%user);
		print "$text{'udel_done'}<p>\n";
		}
	
	print "$text{'udel_pass'}<br>\n";
	&delete_user(\%user);
	print "$text{'udel_done'}<p>\n";

	print "$text{'udel_groups'}<br>\n";
	foreach $g (&list_groups()) {
		@mems = split(/,/, $g->{'members'});
		$idx = &indexof($user{'user'}, @mems);
		if ($idx >= 0) {
			splice(@mems, $idx, 1);
			%newg = %$g;
			$newg{'members'} = join(',', @mems);
			&modify_group($g, \%newg);
			}
		$mygroup = $g if ($g->{'group'} eq $user{'user'});
		}
	print "$text{'udel_done'}<p>\n";

	if ($mygroup && !$mygroup->{'members'}) {
		local $another;
		foreach $ou (&list_users()) {
			$another++ if ($ou->{'gid'} == $mygroup->{'gid'});
			}
		if (!$another) {
			print "$text{'udel_ugroup'}<br>\n";
			&delete_group($mygroup);
			print "$text{'udel_done'}<p>\n";
			}
		}
	&unlock_user_files();
	&made_changes();

	if ($in{'delhome'} && $user{'home'} !~ /^\/+$/) {
		print "$text{'udel_home'}<br>\n";
		if ($config{'delete_only'}) {
			&lock_file($user{'home'});
			&system_logged("find \"$user{'home'}\" ! -type d -user $user{'uid'} | xargs rm -f >/dev/null 2>&1");
			&system_logged("find \"$user{'home'}\" -type d -user $user{'uid'} | xargs rmdir >/dev/null 2>&1");
			rmdir($user{'home'});
			&unlock_file($user{'home'});
			}
		else {
			&system_logged("rm -rf \"$user{'home'}\" >/dev/null 2>&1");
			}
		print "$text{'udel_done'}<p>\n";
		}
	%p = ( %in, %user );
	delete($p{'pass'});
	&webmin_log("delete", "user", $user{'user'}, \%p);

	print "<hr>\n";
	&footer("", $text{'index_return'});
	}
else {
	# Check if something has changed
	if ($user{'user'} ne $in{'user'}) {
		print "<b>$text{'udel_echanged'}</b> <p>\n";
		print "<hr>\n";
		&footer("", $text{'index_return'});
		exit;
		}

	# Ask if the user is sure
	print "<form action=delete_user.cgi>\n";
	print "<input type=hidden name=num value=\"$in{'num'}\">\n";
	print "<input type=hidden name=user value=\"$user{'user'}\">\n";
	print "<input type=hidden name=confirmed value=1>\n";

	if ($user{'home'} ne "/" && -d $user{'home'}) {
		$size = &disk_usage_kb($user{'home'});
		print "<center><h3>",&text('udel_sure', $user{'user'},
					   $user{'home'}, $size),"</h3>\n";
		print "<input type=submit value=\"$text{'udel_del1'}\">\n";
		print "<input name=delhome type=submit ",
		      "value=\"$text{'udel_del2'}\">\n";

		# check for files owned by other users
		@others = `find \"$user{'home'}\" ! -user $user{'uid'} 2>/dev/null`;
		if (@others) {
			print "<h3><font color=#ff0000>",
			      &text('udel_others', "<tt>$user{'home'}</tt>", scalar(@others)),
			      "</font></h3>\n";
			}
		}
	else {
		print "<center><h3>",&text('udel_sure2',
					   $user{'user'}),"</h3>\n";
		print "<input type=submit value=\"$text{'udel_del1'}\">\n";
		}
	print "<br><input type=checkbox name=others value=1 checked> ",
	      "$text{'udel_dothers'}<br>\n";
	if ($user{'user'} eq 'root') {
		print "<center><h3><font color=#ff0000>$text{'udel_root'}",
		      "</font></h3></center>\n";
		}
	print "</form></center>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	}

