#!/usr/local/bin/perl
# delete_mod.cgi
# Delete selected modules from usermin

require './usermin-lib.pl';
$access{'mods'} || &error($text{'acl_ecannot'});
&ReadParse();
&error_setup($text{'delete_err'});
@mods = split(/\0/, $in{'mod'});
@mods || &error($text{'delete_enone'});

local %miniserv;
&get_usermin_miniserv_config(\%miniserv);

# check if any other module depends on those to be deleted
foreach $minfo (&list_modules()) {
	if (&check_usermin_os_support($minfo)) {
		foreach $d (split(/\s+/, $minfo->{'depends'})) {
			$depends{$d} = $minfo->{'desc'};
			}
		}
	}
foreach $m (@mods) {
	%minfo = &get_usermin_module_info($m);
	%minfo = &get_usermin_theme_info($m) if (!%minfo);
	if (!-l "$miniserv{'root'}/$m" && $depends{$m}) {
		&error(&text('delete_edep', "<tt>$minfo{'desc'}</tt>",
			     "<tt>$depends{$m}</tt>"));
		}
	}

# ask the user if he is sure
if (!$in{'confirm'}) {
	&header($text{'delete_title'}, "");
	print "<hr>\n";
	print "<p><form action=delete_mod.cgi>\n";
	foreach $m (@mods) {
		local %minfo = &get_usermin_module_info($m);
		if (!%minfo) {
			$theme++;
			%minfo = &get_usermin_theme_info($m);
			}
		print "<input type=hidden name=mod value=$m>\n";
		$total += &disk_usage_kb("$miniserv{'root'}/$m")
			if (!-l "$miniserv{'root'}/$m");
		$descs .= " , " if ($descs);
		$descs .= "<b>$minfo{'desc'}</b>";
		}
	print "<center>",&text($theme ? 'delete_rusure2' : 'delete_rusure',
			       int($total), $descs),"<p>",
	      "<input type=submit name=confirm value='$text{'delete'}'>",
	      "</form></center><hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

# delete the selected modules or themes
foreach $m (split(/\0/, $in{'mod'})) {
	next if (!$m || !-d "$miniserv{'root'}/$m");
	local (%minfo, %cinfo);
	%minfo = &get_usermin_module_info($m);
	%minfo = &get_usermin_theme_info($m) if (!%minfo);
	if ($minfo{'clone'}) {
		# Deleting a clone
		&read_file("$config{'usermin_dir'}/$m/clone", \%cinfo);
		unlink("$miniserv{'root'}/$m");
		system("rm -rf $config{'usermin_dir'}/$m");
		if ($gconfig{'theme'}) {
			unlink("$miniserv{'root'}/$gconfig{'theme'}/$m");
			}
		push(@mdesc, &text('delete_desc1', $minfo{'desc'},
				   $minfo{'clone'}));
		}
	else {
		# Delete any clones of this module
		local @mst = stat("$miniserv{'root'}/$m");
		opendir(DIR, $miniserv{'root'});
		foreach $l (readdir(DIR)) {
			@lst = stat("$miniserv{'root'}/$l");
			if (-l "$miniserv{'root'}/$l" && $lst[1] == $mst[1]) {
				unlink("$miniserv{'root'}/$l");
				system("rm -rf $config{'usermin_dir'}/$l");
				}
			}
		closedir(DIR);

		open(TYPE, "$miniserv{'root'}/$m/install-type");
		chop($type = <TYPE>);
		close(TYPE);

		# Deleting the real module
		$pwd = "$miniserv{'root'}/$m";
		local $size = &disk_usage_kb($pwd);
		push(@mdesc, &text('delete_desc2', "<b>$minfo{'desc'}</b>",
				   "<tt>$pwd</tt>", $size));
		if ($type eq 'rpm') {
			# This module was installed from an RPM .. rpm -e it
			system("rpm -e wbm-$m");
			}
		else {
			# Module was installed from a .wbm file .. just rm it
			system("rm -rf $miniserv{'root'}/$m");
			}
		}
	&webmin_log("delete", undef, $m, { 'desc' => $minfo{'desc'} });
	}
unlink("$config{'usermin_dir'}/module.infos.cache");

&header($text{'delete_title'}, "");
print "<hr>\n";
print $text{'delete_msg'},"<p>\n";
print "<ul>\n";
for($i=0; $i<@mdesc; $i++) {
	print $mdesc[$i],"<p>\n";
	}
print "</ul><p>\n";
print "<hr>\n";
&footer("", $text{'index_return'});

