#!/usr/local/bin/perl
# newkey.cgi
# Create a new SSL key for Usermin

require './usermin-lib.pl';
$access{'ssl'} || &error($text{'acl_ecannot'});
&ReadParse();

# Validate inputs
&error_setup($text{'newkey_err'});
$in{'commonName_def'} || $in{'commonName'} =~ /^[A-Za-z0-9\.\-]+$/ ||
	&error($text{'newkey_ecn'});
$in{'newfile'} || &error($text{'newkey_efile'});

&header($text{'newkey_title'}, "");
print "<hr>\n";

%aclconfig = &foreign_config('acl');
if (!&has_command($aclconfig{'ssleay'})) {
	print "<p>",&text('newgen_ecmd', "<tt>$aclconfig{'ssleay'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?acl"),"<p>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}

# Create key file
$ctemp = &tempname();
$ktemp = &tempname();
$outtemp = &tempname();
open(CA, "| $aclconfig{'ssleay'} req -newkey rsa:512 -x509 -nodes -out $ctemp -keyout $ktemp -days 1825 >$outtemp 2>&1");
print CA ($in{'countryName'} || "."),"\n";
print CA ($in{'stateOrProvinceName'} || "."),"\n";
print CA ".\n";
print CA ($in{'organizationName'} || "."),"\n";
print CA ($in{'organizationalUnitName'} || "."),"\n";
print CA ($in{'commonName_def'} ? "*" : $in{'commonName'}),"\n";
print CA ($in{'emailAddress'} || "."),"\n";
close(CA);
$rv = $?;
$out = `cat $outtemp`;
unlink($outtemp);
if (!-r $ctemp || !-r $ktemp || $?) {
	print "<p>$text{'newkey_essl'}<br>\n";
	print "<pre>$out</pre>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
&lock_file($in{'newfile'});
$catout = `cat $ctemp $ktemp 2>&1 >'$in{'newfile'}'`;
unlink($ctemp);
unlink($ktemp);
if ($catout || $?) {
	print "<p>$text{'newkey_ecat'}<br>\n";
	print "<pre>$catout</pre>\n";
	print "<hr>\n";
	&footer("", $text{'index_return'});
	exit;
	}
chmod(0600, $in{'newfile'});
&unlock_file($in{'newfile'});

print "<p>$text{'newkey_ok'}<br>\n";
$key = `cat '$in{'newfile'}'`;
print "<pre>$key</pre>";
print "<hr>\n";
&footer("", $text{'index_return'});

# Configure usermin to use the new file
if ($in{'usenew'}) {
	&lock_file($usermin_miniserv_config);
	&get_usermin_miniserv_config(\%miniserv);
	$miniserv{'keyfile'} = $in{'newfile'};
	delete($miniserv{'certfile'});
	&put_usermin_miniserv_config(\%miniserv);
	&unlock_file($usermin_miniserv_config);
	&restart_usermin_miniserv();
	&webmin_log("newkey", undef, undef, \%in);
	}

